/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_calendar.c -- calendars table management functions */

#ifndef _SQL_CALENDAR_H
#define _SQL_CALENDAR_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_cal_list OF((
			int workload_date,
			lwc_LL **rows,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_only_list OF((
			int workload_date,
			lwc_LL **rows,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_get_main OF((int workload_date, const char *id,
			lwc_LL **row,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_get_details OF((int workload_date,
			const char *id,
			void (*set_cal_id)(const char *, void *),
			void (*set_cal_parent)(const char *, void *),
			void (*set_cal_name)(const char *, void *),
			void (*set_cal_type)(const char *, void *),
			void (*set_cal_descr)(const char *, void *),
			void (*set_cal_formula)(const char *, void *),
			void *user_data_set_cal,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_get_parent OF((int workload_date,
			const char *parent_id,
			lwc_LL **rows,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

extern unsigned int sql_cal_update OF((const char *id,
			const char *name,
			const char *description,
			const char *formula,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_delete OF((char **cal_id_array,
			unsigned int len_array,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_reparent OF((const char *parent_id,
			const char *id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_cal_new OF((const char *name,
			const char *parent_id,
			const char *type,
			const char *description,
			const char *formula,
			unsigned long int *new_env_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_calendar.h */

/*-----------------============== End Of File ==============-----------------*/
