/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* gschedwi_jobtree.h -- Function to access the job/jobset tree */

#ifndef _GSCHEDWI_JOBTREE_H
#define _GSCHEDWI_JOBTREE_H

#include <schedwi.h>

#include <schedwi_time.h>
#include <job_status_state.h>
#include <lwc_linkedlist.h>
#include <schedwi_time.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

/* A job/jobset node structure */
struct _schedwi_jobtree_node {
	struct _schedwi_jobtree_node *parent, *children;
	struct _schedwi_jobtree_node *next, *prev;

	unsigned long long int id;
	schedwi_time run_time;    /* Start date and time of this job/jobset */
	schedwi_time start_time;  /* Real start time */

	/* Max number of seconds for this job/jobset to be started */
	long int start_limit;

	/* Max number of seconds for this job/jobset to complete */
	long int max_duration;

	/* Average duration of the job in seconds (job_stat table) */
	long int average_duration;

	/* Last run duration of the job in seconds (job_stat table) */
	long int last_run_duration;

	/* Completion percentage */
	unsigned short int run_pct;

	/* Node type: 0 --> Jobset   1 --> Job */
	char node_type;

	/* Current status of the job/jobset */
	job_status_state status;

	/* Message associated with the status */
	char *status_message;
};
typedef struct _schedwi_jobtree_node schedwi_jobtree_node;
typedef struct _schedwi_jobtree_node *schedwi_jobtree_node_ptr;


/* Element definition of the job/jobset arrays in the struct _jobtree (below)*/
struct _jobtree_jobs {
	unsigned long long int id;
	schedwi_jobtree_node_ptr node;
};
typedef struct _jobtree_jobs jobtree_jobs;
typedef struct _jobtree_jobs *jobtree_jobs_ptr;


/* Tree meta-informations */
struct _jobtree {
	/* Top jobset node */
	schedwi_jobtree_node_ptr top;

	/* Ordered array of all the job/jobsets in the tree */
	jobtree_jobs_ptr jobs;

	/* Number of jobs in the tree */
	unsigned int nb_jobs;

	/* Date */
	schedwi_date date;
};
typedef struct _jobtree jobtree;
typedef struct _jobtree *jobtree_ptr;


extern schedwi_jobtree_node_ptr jobtree_find OF((jobtree_ptr tree,
					    unsigned long long int id));
extern jobtree_ptr new_jobtree OF((schedwi_date date));
extern void free_jobtree OF((jobtree_ptr ptr));
extern int schedwi_jobtree_is_completed OF((jobtree_ptr ptr));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* gschedwi_jobtree.h */

/*-----------------============== End Of File ==============-----------------*/
