#include <schedwi.h>
/*
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
*/

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"


#include <hosts_cb.h>
#include <host_cb.h>
#include <certificate_cb.h>
#include <env_widget.h>
#include <env_window_cb.h>
#include <env_list_cb.h>
#include <calendar_list_cb.h>
#include <calendar_folder_cb.h>
#include <calendar_cal_cb.h>
#include <link.h>
#include <job_cb.h>
#include <navigator.h>
#include <main_cb.h>
#include <find_cb.h>
#include <schedwi_main.h>
#include <pref_cb.h>
#include <login_cb.h>
#include <druid_cb.h>
#include <background.h>
#include <workload.h>
#include <database_test_cb.h>


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (schedwi_main_quit () == FALSE) {
		schedwi_main_destroy ();
	}
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_preferences_activated (menuitem);
}


void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *about;
	about = create_about1 ();
	gtk_widget_show (about);
}


void
on_properties2_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_properties (menuitem);
}


void
on_button_host_edit_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_edit_clicked (button);
}


void
on_button_host_refresh_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_refresh_clicked (button);
}


void
on_button_host_where_used_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_where_used_clicked (button);
}


void
on_button_env_edit_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	env_edit_clicked (button);
}


void
on_button_env_where_used_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	env_where_used_clicked (button);
}


void
on_button_env_refresh_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	env_list_refresh_clicked (button);
}


void
on_show_hosts_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_hosts_activate (menuitem);
}


void
on_show_environments_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_environments_activate (menuitem);
}


void
on_show_calendars_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_calendars_activate (menuitem);
}


gboolean
on_application_main_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return schedwi_main_quit ();
}

void
on_button_certificate_save_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	certificate_save (button);
}


void
on_button_host_view_certificate_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	host_view_certificate_view_clicked (button);
}


gboolean
on_dialog_cal_list_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return calendar_list_delete_event (widget);
}


void
on_button_cal_close_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_close_clicked (button);
}


void
on_button_cal_list_year_prev_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_year_prev_clicked (button);
}


void
on_button_cal_list_year_next_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_year_next_clicked (button);
}


void
on_button_cal_refresh_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_refresh_clicked (button);
}


gboolean
on_treeview_cal_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return calendar_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_cal_popup_menu             (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return calendar_on_treeview_cal_popup_menu (widget);
}


void
on_host_list_edit_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_edit_menu (menuitem);
}


void
on_host_list_references_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_where_used_menu (menuitem);
}


void
on_env_list_edit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_edit_menu (menuitem);
}


void
on_env_list_references_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_where_used_menu (menuitem);
}


gboolean
on_treeview_hosts_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return hosts_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_hosts_popup_menu           (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return hosts_on_treeview_cal_popup_menu (widget);
}


gboolean
on_treeview_environments_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return env_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_environments_popup_menu    (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return env_on_treeview_cal_popup_menu (widget);
}


void
on_cal_menu_edit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_edit_menu (menuitem);
}


void
on_cal_menu_references_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_where_used_menu (menuitem);
}


void
on_okbutton_cal_folder_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	cal_folder_ok_clicked (button);
}


void
on_button_cal_edit_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_edit_clicked (button);
}


void
on_button_cal_year_prev_preview_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_year_prev_clicked (button);
}


void
on_button_cal_year_next_preview_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_year_next_clicked (button);
}


gboolean
on_dialog_cal_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

	calendar_cal_delete_event (widget);
	return FALSE;
}


void
on_button_cal_where_used_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_where_used_clicked (button);
}


gboolean
on_dialog_host_list_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return host_list_delete_event (widget);
}


void
on_button_host_list_close_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	host_list_close_clicked (button);
}


gboolean
on_dialog_env_list_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return env_list_delete_event (widget);
}


void
on_button_env_list_close_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	env_list_close_clicked (button);
}


void
on_location_bar_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	location_bar_activate (menuitem);
}


void
on_zoomin_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	zoomin_activate ();
}


void
on_zoomout_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	zoomout_activate ();
}


void
on_normal_size_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	normal_size_activate ();
}


void
on_status_bar_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	status_bar_activate (menuitem);
}


gboolean
on_eventbox_main_navigator_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return eventbox_main_navigator_button_press (widget, event);
}


void
on_button_main_zoom_out_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	zoomout_activate();
}


void
on_button_main_zoom_in_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	zoomin_activate ();
}


gboolean
on_canvas_main_scroll_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return canvas_main_scroll_event (widget, (GdkEventScroll *)event);
}


void
on_refresh_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	reload_activate (menuitem);
}


void
on_toolbutton_refresh_clicked          (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	reload_tool_activate (toolbutton);
}


void
on_entry_main_location_activate        (GtkEntry        *entry,
                                        gpointer         user_data)
{
	location_activate (entry);
}


void
on_button_find_select_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	find_select_clicked (button);
}


void
on_button_find_close_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	find_close_clicked (button);
}


void
on_entry_find_activate                 (GtkEntry        *entry,
                                        gpointer         user_data)
{
	find_entry_activate (entry);
}


void
on_button_find_find_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	find_button_clicked (button);
}


gboolean
on_dialog_find_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return find_delete_event (widget);
}


void
on_toolbutton_find_clicked             (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_find_clicked (toolbutton);
}


void
on_find_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_find_activated (menuitem);
}


void
on_entry_pref_database_server_changed  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_host_changed_cb (GTK_ENTRY (editable));
}


void
on_entry_pref_database_name_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_database_changed_cb (GTK_ENTRY (editable));
}


void
on_fileentry_database_socket_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_socket_changed_cb (editable);
}


void
on_spinbutton_pref_cal_num_month_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_calendar_months_by_row_changed_cb (spinbutton);
}


void
on_combobox_pref_cal_first_day_changed (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	pref_calendar_first_day_of_week_changed_cb (combobox);
}


void
on_fontbutton_pref_cal_font_font_set   (GtkFontButton   *fontbutton,
                                        gpointer         user_data)
{
	pref_calendar_font_set_cb (fontbutton);
}


void
on_radiobutton_pref_cal_font_theme_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	pref_calendar_use_system_font_toggled_cb (togglebutton);
}


gboolean
on_dialog_preferences_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return pref_delete_event (widget);
}


void
on_closebutton_pref_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_close_clicked (button);
}


void
on_entry_pref_database_username_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_user_changed_cb (GTK_ENTRY (editable));
}


void
on_spinbutton_pref_database_port_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_database_port_changed_cb (spinbutton);
}


void
on_button_pref_database_revert_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_database_restore_activated_cb (button);
}


void
on_button_pref_database_test_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_database_test_clicked_cb (button);
}


void
on_button_database_test_connect_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	database_test_go_clicked (button);
}


void
on_database_assistant_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	database_assistant_activate (menuitem);
}


void
on_login1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	login_activate (menuitem);
}


void
on_logout1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	logout_activate (menuitem);
}


void
on_button_login_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	login_clicked (button);
}


void
on_button_druid_connect_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	druid_test_database_clicked (button);
}


void
on_druidpagefinish1_finish             (GnomeDruidPage  *gnomedruidpage,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
	druid_finish_clicked (gnomedruidpage, widget);
}


void
on_default_job_parameters1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	job_cb_on_default_parameters_activated (menuitem);

}


void
on_statistics1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_statistics (menuitem);
}


void
on_combobox_main_workload_changed      (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	combobox_changed (combobox);
}


void
on_spinbutton_main_update_interval_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	workload_update_interval (spinbutton);
}


void
on_start_now1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_start (menuitem);
}


void
on_stop_now1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_stop (menuitem);
}


void
on_force_to_completed1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_status_completed (menuitem);
}


void
on_force_to_failed1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_status_failed (menuitem);
}


void
on_force_to_waiting1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_status_waiting (menuitem);
}

