#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;
use File::Temp ;

use SchedView::IHM ;
use SchedView::Display ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}


sub add
{
    my ($host, $ip, $info) = @_ ;

    $dbh->begin_work() ;
    
    my $sth = $dbh->prepare("
INSERT INTO host (name,ip,info) 
VALUES (?,?,?)") ;

    if ($sth->execute($host, $ip, $info)) {
	print "Ok" ;
    } else {
	print "E : ", $sth->errstr ;
	return
    }
    
    $sth = $dbh->prepare("
SELECT host_no FROM host
WHERE  name = ? and ip = ?
") ;
    $sth->execute($host, $ip) ;
    my ($id) = $sth->fetchrow_array() ;
    
    for my $g (CGI::param('group')) {
	next if ($g !~ /^([\w\d\._-]+)$/) ;
	$g = $1 ;
	
	$sth = $dbh->prepare("
INSERT INTO hostgroup_member (host_no, hostgroup_no) 
VALUES (?, 
	(SELECT hostgroup_no FROM hostgroup WHERE name = ?) 
       )") ;
	$sth->execute($id, $g) || exit ;
    }
    
    $dbh->commit() ;
}

sub modify
{
    my ($host, $ip, $info) = @_ ;

    $dbh->begin_work() ;
	
    my $old_ip = CGI::param('old_ip') || '' ;
    
    if ($old_ip =~ /^(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})$/) {
	$old_ip = $1 ;
    } else {
	print "E : Old Host adress invalid" ;
	return ;
    }

    my $old_host = CGI::param('old_host') || '' ;
    
    if ($old_host =~ /^([\w\d+\._-]+)$/) {
	$old_host = $1 ;
    } else {
	print "E : Old Hostname invalid" ;
	return ;
    }
    
    my $sth = $dbh->prepare("
UPDATE host SET name = ?, ip = ?,info = ? 
WHERE  name = ? and ip = ?
") ;
    if ($sth->execute($host, $ip, $info, $old_host, $old_ip)) {
	print "Ok" ;
    } else {
	print "E : ", $sth->errstr ;
	return ;
    }

    $sth = $dbh->prepare("
SELECT host_no FROM host
WHERE  name = ? and ip = ?
") ;
    $sth->execute($host, $ip) ;
    my ($id) = $sth->fetchrow_array() ;
    
    $sth = $dbh->prepare("DELETE FROM hostgroup_member WHERE host_no = ?");
    $sth->execute($id) || return ;

    for my $g (CGI::param('group')) {
	next if ($g !~ /^([\w\d\._-]+)$/) ;
	$g = $1 ;
	
	$sth = $dbh->prepare("
INSERT INTO hostgroup_member (host_no, hostgroup_no) VALUES (?, 
	(SELECT hostgroup_no FROM hostgroup WHERE name = ?) )
") ;
	$sth->execute($id, $g) || return ;
    }
    $dbh->commit() ;
}

sub edit
{
    my ($host, $ip) = @_ ;

    print CGI::start_form(-methode => 'GET') ;
    $Sched::log->write("host = $host ; ip = $ip") ;
    SchedView::Display::edit_host(host => $host, 
				  ip => $ip,
				  dbh => $dbh) ;
    
    print CGI::hidden(-name => 'old_host',
		      -default => $host) ;
    
    print CGI::hidden(-name => 'old_ip',
		      -default => $ip) ;
    
    print CGI::end_form() ;

}

sub delete_host
{
    my ($host, $ip) = @_ ;
    
    my $sth = $dbh->prepare("
DELETE FROM host
WHERE  name = ? and ip = ?
") ;
    if ($sth->execute($host, $ip)) {
	print "Delete $host : Ok" ;
    } else {
	print "E : ", $sth->errstr ;
    }
}

print CGI::header('text/html') ;
#print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

SchedView::IHM::insert_begin('Manage Host') ;
SchedView::IHM::insert_title('Manage Host') ;

print "<td>\n" ;

if (CGI::param()) {

    my $action = CGI::param('action')  || '';

    my $info = CGI::param('info') || 'No comment' ;
    $info =~ s/'";/ /g ; # '
    $info =~ /^(.+)$/ ;
    $info = $1 ;
    
    my $host = CGI::param('host') || '' ;
    my $ip   = CGI::param('ip') || '' ;
    
    if ($ip =~ /^(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})$/) {
	$ip = $1 ;
    } else {
	print "E : Host adress invalid" ;
	exit 0 ;
    }
	
    if ($host =~ /^([\w\d+\._-]+)$/) {
	$host = $1 ;
    } else {
	print "E : Hostname invalid" ;
	exit 0 ;
    }
	    
    if ($action eq 'Add') {
	add($host, $ip, $info) ;
	print "<br/><a href='javascript:window.history.go(-2)'> Back </a>" ;
    } elsif ($action eq 'Modify') {
	modify($host, $ip, $info) ;
	edit($host, $ip) ;
    } elsif ($action eq 'Del') {
	print CGI::start_form() ;
	print
	   CGI::p("Do you realy want to delete $host ($ip) ?"),
	   CGI::hidden(-name => "host", -value => $host),
	   CGI::hidden(-name => "ip", -value => $ip),
	   CGI::submit(-name => "action", -value => "Delete") ;
	print CGI::end_form() ;
    } elsif ($action eq 'Delete') {
   	delete_host($host, $ip) ; 
	print "<br/><a href='javascript:window.history.go(-2)'> Back </a>" ;
    } else {
	edit($host, $ip) ;
    }

} else {
    print CGI::start_form() ;
    SchedView::Display::add_host(dbh => $dbh) ;
    print CGI::end_form() ;
}

print "</td>\n" ;
SchedView::IHM::insert_end() ;

#print CGI::end_html() ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

