#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;

use SchedView::Display ;
use SchedView::IHM ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}

print CGI::header('text/html') ;

SchedView::IHM::insert_begin('Running Job') ;
SchedView::IHM::insert_title('Running job list') ;

my $q = $dbh->prepare(
"SELECT job_hist.job_sid, 
        date_trunc('second',job_hist.start_date),
        job_hist.host, job.id 
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no 
WHERE end_date is null"
) ;

$q->execute() ;

print "
<table class='status'>
<tr>
<th CLASS='status'>Host&nbsp;</th>
<th CLASS='status'>Job&nbsp;</th>
<th CLASS='status'>Start date&nbsp;</th>
<th CLASS='status'>Information&nbsp;</th>
</tr>
" ;
my $c="Odd" ;
while (my ($job_sid, $start_date, $host, $id) = $q->fetchrow_array()) 
{
    $c = ($c eq "Odd")?'Even':'Odd' ;
    print "<tr><td align='left' valign='center' class='status$c'>$host</td><td align='left' valign='center' class='status$c'>$id</td><td align='left' valign='center' class='status$c'>$start_date</td><td align='left' valign='center' class='status$c'><a href='/cgi-bin/sched/sched_get_view.cgi?sid=$job_sid'>display</td></tr>\n" ;
}
print "</table><hr/>\n" ;


SchedView::IHM::insert_end() ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

