#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;
use XML::Mini::Document ;

use Sched::Cond ;
use Sched::NS ;
use Sched::Cmd ;

my ($w, $h) = (100,60) ;
my ($default_width, $default_height) = (800, 600) ;
my $xml ;

sub calc_xy
{
    # pos permet de deplacer legerement le pt d'ancrage
    my ($parent, $child, $pos) = @_ ;
    
    $pos = $pos || 0 ;

    # $x et $y en haut a gauche
    my ($xp, $yp) = ($parent->attribute('x'), $parent->attribute('y')) ;

    my ($xc, $yc) = ($child->attribute('x'), $child->attribute('y')) ;

    # resultat
    my ($xlc, $ylc, $xlp, $ylp) ;

    if (($xc + $w) <= $xp) {
	$xlc = $xc + $w ;
	$ylc = $yc + $h/2 + $pos ;

	$xlp = $xp ;
	$ylp = $yp + $h/2 + $pos ;
    } elsif ($xc >= ($xp + $w)) {
	$xlc = $xc ;
	$ylc = $yc + $h/2 + $pos ;

	$xlp = $xp + $w ;
	$ylp = $yp + $h/2 + $pos ;
    } elsif ($yc >= ($yp + $h)) {
	$xlc = $xc + $w/2 + $pos ;
	$ylc = $yc ;

	$xlp = $xp + $w/2 + $pos ;
	$ylp = $yp + $h ;
    } elsif ($yc <= $yp) {
	$xlc = $xc + $w/2 + $pos ;
	$ylc = $yc + $h ;

	$xlp = $xp + $w/2 + $pos ;
	$ylp = $yp ;
    } else {
	$xlc = $xc ;
	$xlp = $xp ;

	$ylc = $yc ;
	$ylp = $yp ;
    }


    return ($xlp, $ylp, $xlc, $ylc) ;
}

use MIME::Base64 q/decode_base64/ ;

sub xml2svg_comment
{
    my $root = shift ;

    return if (!$root) ;

    for my $c (@{ $root->getAllChildren('comment') }) {
	my $id = $c->attribute('id') ;
	my ($x, $y) = ($c->attribute('x'), $c->attribute('y')) ;
	my $text = decode_base64($c->attribute('text')) ;

	my @l = sort { $b <=> $a } map { length } split(/\n/, $text) ;
	my $len = $l[0] ;

	my $cr = ($text =~ tr/\n//) || 1;

	my ($w, $h) = (40 + $len*8, 30 + $cr*20) ;

	my ($xl, $yl) = ($x + 20 + $len*4, $y + 15 + $cr*10) ;

	
print "
<svg:g>
 <svg:rect id='$id' rx='5' width='$w' height='$h'
  x='$x' y='$y'
  style='fill-opacity: 0.5; fill : yellow ; opacity: 0.5'/>
 <svg:text id='text $id' x='$xl' y='$yl' 
  style='text-anchor:middle'>$text</svg:text>
</svg:g>
" ;


    }
}

sub xml2svg_task
{
    my $root = shift ;
    
    return if (!$root) ;

    my $id = $root->attribute('id') ;

    my ($x, $y) = ($root->attribute('x'), $root->attribute('y')) ;
    my ($xl, $yl) = ($x + $w/2, $y + $h/2) ;
    print "
<svg:g>
 <svg:rect id='$id' rx='5' width='$w' height='$h'
  x='$x' y='$y'
  style='fill-opacity: 0.5; fill : EEFF00 ; opacity: 0.5'/>
 <svg:text id='text $id' x='$xl' y='$yl' 
  style='text-anchor:middle'>$id</svg:text>
</svg:g>
" ;
    
    # si condition ok => blue, condition err => red, sinon green

    # %lst = ('task1' => 'green',
    #         'task2' => 'red',..) ;
    my %lst = map { $_ => 'brown' } Sched::Cond::depend_of($root) ;

    my $cond = MIME::Base64::decode_base64($root->attribute('cond') || '') ;

    map { $lst{$_} = 'green'  } Sched::Cond::depend_on_ok($cond) ;
    map { $lst{$_} = 'red' } Sched::Cond::depend_on_err($cond) ;
    map { $lst{$_} = '#b0e2ff' } Sched::Cond::depend_on_finish($cond) ;

    for my $i (keys %lst) {
	my $t = Sched::Cmd::find_task_by_id($xml, $i) 
	    || die "E : erreur de cond";
	
	my ($xa, $ya, $xb, $yb) = calc_xy($root, $t, $w/10) ;

	print "
<svg:line x1='$xa' x2='$xb' y1='$ya' y2='$yb' 
style=\"marker-end:url(#arrow_cond); stroke-width:2; stroke-dasharray:'10,2'; stroke:$lst{$i}; fill:none;\" />
" ;
    }

    for my $c (@{ $root->getAllChildren('task') }) {
	my ($xa, $ya, $xb, $yb) = calc_xy($root, $c) ;

	print "
<svg:line x1='$xa' x2='$xb' y1='$ya' y2='$yb' 
style='fill: EE00EE; marker-end: url(#arrow_parent); stroke: gray' />
" ;
	xml2svg_task($c) ;
    }
}


die "E : initialisation impossible" if (!CGI::param()) ;

my $sid = CGI::param('sid') ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}
    
my $q = $dbh->prepare('SELECT job.xml 
    FROM job INNER JOIN job_hist ON job_hist.job_no = job.job_no 
    WHERE job_sid=?') ;

$q->execute($sid) ;

my ($string) = $q->fetchrow_array() ;

if (!$string) {
    print CGI::header(),
          "<h1>Impossible de trouver $sid</h1>",
	  CGI::end_html() ;
    exit(0) ;
}

my $width = CGI::param('width')   || $default_width;
if ($width =~ /^(\d+)$/) {
    $width = $1 ;
} else {
    $width = $default_width ;
}

my $height = CGI::param('height') || $default_height ;
if ($height =~ /^(\d+)$/) {
    $height= $1 ;
} else {
    $height = $default_height ;
}

my $doc = new XML::Mini::Document() ;
$doc->parse($string) ;
$xml = $doc->getRoot()->getElement('job') ;

print CGI::header(-type=>'application/vnd.mozilla.xul+xml') ;
print '<?xml version="1.0"?>
<?xml-stylesheet href="chrome://global/skin" type="text/css"?>
<window xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
        xmlns:svg="http://www.w3.org/2000/svg"
        xmlns:html="http://www.w3.org/TR/REC-html40">
<script src="/sched/func.js" type="text/javascript"/>
<vbox>
<menubar>
<!--
        <menu label="File" /> -->
        <menu label="Action"> 
	  <menupopup>
		<menuitem label="Update Status" oncommand="on_update_status()"/>
		<menuitem id="_watch" label="Auto Update" oncommand="on_auto_update()" checked="false"/>
		<menuseparator/>
        	<menuitem label="Cancel Job" oncommand="on_cancel_job()"/>
        	<menuitem label="Cancel Task" oncommand="on_cancel()"/>
	  </menupopup>
	</menu>
        <button label="Zoom Fit" oncommand="on_zoom_show_all()"/>
        <button label="Zoom In" oncommand="scale_in()"/>
        <button label="Zoom Out" oncommand="scale_out()"/>
	<button label="Update" oncommand="on_update()"/>
  </menubar>

<hbox>

<box style="overflow:auto;" width="' . $width . 'px" height="' . $height . 'px">
	<svg:svg width="1600px" height="1400px" id="_svgdoc">

        <svg:defs >
                <svg:marker markerWidth="8" markerHeight="8" orient="auto" refY="4" refX="8" id="arrow_parent">
                        <svg:path style="fill: gray" d="M0 0 8 4 0 8 Z" />
                </svg:marker>
                <svg:marker markerWidth="8" markerHeight="8" orient="auto" refY="4" refX="8" id="arrow_cond">
                        <svg:path style="fill: red" d="M0 0 8 4 0 8 Z" />

                </svg:marker>
        </svg:defs>


<svg:g id="_all">
 <svg:g id="_task">
' ;

xml2svg_task($xml) ;

print '
 </svg:g>
' ;

xml2svg_comment($xml) ;

print '

</svg:g>
	</svg:svg>

	</box>
<vbox>
<!--
<grid> 
  <columns>
    <column flex="1"/>
    <column flex="1"/>
  </columns>
-->
<!--
   <rows> 
     <row flex="1"> 
       <label value="Id" />
       <textbox id="_id" value="" />
     </row> 

   </rows> 
 </grid> 
-->
<label id="_sync_date"/>

<tabbox orient="vertical"> 
  <tabs orient="horizontal"> 
        <tab label="Info" /> 
        <tab label="Advance" /> 
  </tabs> 
                              
  <tabpanels flex="100%"> 
    <tabpanel>
        <box>
        <grid> 
	<rows> 
	 <row> 
         <label value="Id" />
         <textbox id="_id" value="" />
         </row> 
     <row> 
       <label value="State" />
       <textbox id="_state" value="" />
     </row> 
     <row> 
       <label value="Status" />
       <textbox id="_status" value="" />
     </row> 
     <row> 
       <label value="Host" />
       <textbox id="_host" value="" />
     </row> 
     <row> 
       <label value="Info" />
       <textbox id="_info" value="" />
     </row> 
     <row>
       <label value="Start Time" />
       <textbox id="_start_date" value="" />
     </row>
     <row>
       <label value="Exec Time" />
       <textbox id="_exec_time" value="" />
     </row> 
     <row>
       <label value="Comment" />
       <textbox id="_comment" value="" multiline="true" wrap="word"/>
     </row> 
        </rows>
        </grid>
        </box>
    </tabpanel>
    <tabpanel>
        <box>
        <grid> 
	<rows> 
     <row>
       <label value="CmdLine" />
       <textbox id="_cmdline" value="" multiline="true"/>
     </row> 
     <row>
       <label value="Condition" />
       <textbox id="_cond" value="" multiline="true"/>
     </row> 
     <row>
       <label value="After Cmd" />
       <textbox id="_after_cmd" value="" multiline="true"/>
     </row> 
     <row>
       <label value="After C. status" />
       <textbox id="_after_cmd_status" value="" />
     </row> 
     <row>
       <label value="Stdin" />
       <textbox id="_stdin" value="" />
     </row> 
     <row>
       <label value="Stdout" />
       <box> <textbox id="_stdout" size="16" value="" />
             <button label="View" oncommand="get_log(\'stdout\')"/>
       </box>
     </row> 
     <row>
       <label value="Stderr" />
       <box> <textbox id="_stderr" size="16" value="" />
             <button label="View" oncommand="get_log(\'stderr\')"/>
       </box>
     </row> 
     <row>
       <label value="Maxtime" />
       <textbox id="_maxtime" value="" />
     </row> 
     <row>
       <label value="User" />
       <textbox id="_user" value="" />
     </row> 
     <row>
       <label value="Group" />
       <textbox id="_group" value="" />
     </row> 
        </rows>
        </grid>
        </box>
    </tabpanel>

  </tabpanels> 
</tabbox> 
</vbox>
</hbox>',"

</vbox>
<script>
 init('$sid') ;
</script>
</window>
" ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut





