#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;
use File::Temp ;

use SchedView::IHM ;
use SchedView::Display ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}

print CGI::header('text/html') ;
#print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

SchedView::IHM::insert_begin('Commit Job') ;
SchedView::IHM::insert_title('Commit Job') ;

print "<td>\n" ;

if (CGI::param()) {
    my $comment = CGI::param('comment') || 'No comment' ;
    $comment =~ s/'";/ /g ; # '
    $comment =~ /^(.+)$/ ;
    $comment = $1 ;

    my $fh = CGI::upload('job_file') ;
    if (!$fh) {
	print "E : job file not found" ;
	exit 0 ;
    }

    # Copy a binary file to somewhere safe
    my ($tempfh, $filename) = File::Temp::tempfile() ;

    my $buffer ;
    read($fh,$buffer,1024) ;

    if ($buffer =~ /^<job/) {
	print $tempfh $buffer ;

	while (read($fh,$buffer,1024)) {
	    print $tempfh $buffer;
	}

	print "<pre>\n" ;
	system("sched_job_commit -j $filename -r '$comment' 2>&1") ;
	print "</pre>\n" ;

	print CGI::br() ;
	if ($? == 0) {
	    print "Commit ok" ;
	} else {
	    print "Error during commit" ;
	}
    } else {
	print "Error during commit" ;
    }

    unlink($filename) ;

} else {
    print 
	CGI::p('File Job selection'),
	CGI::start_multipart_form(),
	CGI::p("Comment :"),
	CGI::textarea(-name=>'comment',
		      -rows=>5,
		      -columns=>50),
	CGI::br(),
	CGI::p("Job file :"),
	CGI::filefield(-name=>'job_file',
		       -size=>44),
	CGI::br(),
	CGI::submit('Commit'),
	CGI::end_form() ;
}

print "</td>\n" ;
SchedView::IHM::insert_end() ;

#print CGI::end_html() ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

