#!/usr/bin/perl -w
use strict ;

my $cgi_url = "/cgi-bin/sched" ;
my $default_limit = 10 ;

package SchedView::Display ;

use CGI ;
use Sched ;

my %req = (
 'select_by_host' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null and job_hist.host = ?
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_job' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null and job.id = ?
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_host_re' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null and job_hist.host ~* ?
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_host_re_critical' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null and job_hist.host ~* ? and job_hist.status!=0
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_job_and_host' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null and job.id = ? and job_hist.host = ? 
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_all' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE end_date is not null 
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_all_critical' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE job_hist.end_date is not null and job_hist.status!=0
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_host_critical' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE job_hist.end_date is not null and job_hist.status!=0 and job_hist.host=?
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_job_and_host_critical' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE job_hist.end_date is not null and job_hist.status!=0 and job.id=? and job_hist.host=?
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'select_by_job_critical' =>
"SELECT job_hist.job_sid AS job_sid, 
       date_trunc('second', job_hist.start_date) AS start_date,
       job_hist.host AS host,
       job.id AS id,
       job_hist.status AS status,
       date_trunc('second',age(job_hist.end_date, job_hist.start_date)) AS time
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE job_hist.end_date is not null and job.id = ? and job_hist.status != 0
ORDER BY start_date DESC OFFSET ? LIMIT ?",

 'give_job_last_start' => 
"SELECT date_trunc('second', job_hist.start_date) AS start_date
FROM job_hist INNER JOIN job ON job.job_no = job_hist.job_no
WHERE job.id = ?
ORDER BY job_hist.start_date DESC LIMIT 1",


 'select_registered_job_by_id' =>
"SELECT job.job_no AS job_no, job.host AS host, job.id AS id,
	date_trunc('second', job.date) AS date, job.comment AS comment
FROM job 
WHERE job.id = ?
ORDER by job.date OFFSET ? LIMIT ?
",
 'select_registered_job' =>
"SELECT DISTINCT ON (job.id) 
	job.job_no AS job_no, job.host AS host, job.id AS id,
	date_trunc('second', job.date) AS date, job.comment AS comment
FROM job
ORDER by job.id, job.date DESC OFFSET ? LIMIT ?
",
'list_all_host' =>
"
SELECT host.name, host.ip
FROM host
ORDER by host.name, host.ip
",
 
 'select_host' =>
"SELECT host.ip AS ip, host.name AS name, 
        host.info AS info, host.online AS online
FROM host
ORDER by host.name OFFSET ? LIMIT ?
",

 'select_host_by_name' =>
"SELECT host.ip AS ip, host.name AS name, 
        host.info AS info, host.online AS online
FROM host
WHERE host.name = ?
",

 'select_host_by_name_ip' =>
"SELECT host.ip AS ip, host.name AS name, 
        host.info AS info, host.online AS online
FROM host
WHERE host.name = ? and host.ip = ?
",


 'select_host_by_no' =>
"SELECT host.ip AS ip, host.name AS name, 
        host.info AS info, host.online AS online
FROM host
WHERE host.host_no = ?
",

 'select_host_by_name_re' =>
"SELECT host.ip AS ip, host.name AS name,
        host.info AS info, host.online AS online
FROM host
WHERE host.name ~* ?
ORDER by host.name OFFSET ? LIMIT ?
",

 'select_host_by_ip' =>
"SELECT host.ip AS ip, host.name AS name, host.info AS info,
        host.online AS online
FROM host
WHERE host.ip = ?
",

 'select_host_by_ip_re' =>
"SELECT host.ip AS ip, host.name AS name, host.info AS info
        host.online AS online
FROM host
WHERE host.ip ~* ?
ORDER by host.name OFFSET ? LIMIT ?
",

 # liste des groupes avec en face une valeur non null si la machine
 # est dedans
 'list_hostgroup_by_name_ip' =>
"SELECT hostgroup.name,hostgroup.info,hostgroup_member.host_no 
 FROM hostgroup 
       LEFT OUTER JOIN hostgroup_member ON 
	  hostgroup.hostgroup_no = hostgroup_member.hostgroup_no 
	      AND 
	  hostgroup_member.host_no = 
               (select host_no from host where name = ? and ip = ?)
 ORDER BY hostgroup.name
",

 'list_hostgroup_by_host_no' =>
"SELECT hostgroup.name,hostgroup.info,hostgroup_member.host_no 
 FROM hostgroup 
       LEFT OUTER JOIN hostgroup_member ON 
	  hostgroup.hostgroup_no = hostgroup_member.hostgroup_no 
	      AND 
	  hostgroup_member.host_no = ?
 ORDER BY hostgroup.name
",

 'list_hostgroup' =>
"SELECT name,info
 FROM hostgroup 
 ORDER BY hostgroup.name
",

 'select_hostgroup' =>
"SELECT hostgroup_no, name,info
 FROM hostgroup 
 ORDER BY hostgroup.name OFFSET ? LIMIT ?
",

'select_hostgroup_by_name' => 
"SELECT hostgroup_no, name, info
 FROM hostgroup
 WHERE name = ?
",

'select_hostgroup_by_name_re' => 
"SELECT hostgroup_no, name, info
 FROM hostgroup
 WHERE name ~ ? OFFSET ? LIMIT ?
",

'select_hostgroup_by_hostgroup_no' => 
"SELECT hostgroup_no, name, info
 FROM hostgroup
 WHERE hostgroup_no = ?
",

 'list_host_by_hostgroup_no' =>
"
SELECT host.name,host.ip,hostgroup_member.hostgroup_no 
 FROM host 
       LEFT OUTER JOIN hostgroup_member ON 
	  host.host_no = hostgroup_member.host_no 
	      AND 
	  hostgroup_member.hostgroup_no = ?
 ORDER BY host.name, host.ip
",

	   ) ;


sub get_offset_limit
{
   my %arg = @_ ;

   my $offset = $arg{offset} || 0 ;

   if ($offset =~ /^(\d+)$/) {
	$offset = $1 ;
   } else {
	$offset = 0 ;
   }

   my $limit  = $arg{limit}  || $default_limit ;

   if ($limit =~ /^(\d+)$/) {
	$limit = $1 ;
   } else {
	$limit = $default_limit ;
   }

   return ($offset, $limit) ;
}

=head1 FUNCTION SchedView::Display::registered_host

    This function display registered host with filter (host, ip, re)

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::registered_host(hostname => 'hostname',

					hostname_re => 'ostname',

					dbh  => $dbh) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL
 o hostname_re : hostname regexp
 o hostname : hostname
 o ip_re : ip regexp
 o ip : ip
 o offset : nb

=cut

sub registered_host
{
    my %arg = @_ ;

    my $host = $arg{hostname} || '' ;
    my $ip   = $arg{ip}       || '' ;

    my $host_re = $arg{hostname_re} || '' ;
    my $ip_re   = $arg{ip_re}       || '' ;

    my ($offset, $limit) = get_offset_limit(%arg) ;

    my $q ; 
    my @sql_arg = () ;


    if ($host =~ /^$Sched::re_host$/) {
	$q = 'select_host_by_name' ;
	push @sql_arg, $1 ;
    } elsif ($ip =~ /^$Sched::re_ip$/) {
	$q = 'select_host_by_ip' ;
	push @sql_arg, $1 ;
    } elsif ($host_re) {
	$q = 'select_host_by_name_re' ;
	push @sql_arg, $host_re, $offset, $limit ;
    } elsif ($ip_re) {
	$q = 'select_host_by_ip_re' ;
	push @sql_arg, $ip_re, $offset, $limit ;
    } else {
	$q = 'select_host' ;
	push @sql_arg, $offset, $limit ;
    }

    my $dbh = $arg{dbh} ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    print '
<table class="status">
<tr>
<th CLASS="status">Hostname&nbsp;</th>
<th CLASS="status">Host address&nbsp;</th>
<th CLASS="status">Information&nbsp;</th>
<th CLASS="status">Options&nbsp;</th>
</tr>
' ;
    my $c="Odd" ;

    while (my ($ip,$hn,$info,$online)=$q->fetchrow_array())
    {
	$c = ($c eq "Odd")?'Even':'Odd' ;

	my $color = $c . (($online)?'Online':'') ;

	print "
<tr>
<td align='left' valign='center' class='status$color'>$hn</td>
<td align='left' valign='center' class='status$color'>$ip</td>
<td align='left' valign='center' class='status$color'>$info</td>
<td align='left' valign='center' class='status$color'>
<a href='$cgi_url/sched_manage_host.cgi?host=$hn;ip=$ip;action=Edit'><img src='/sched/img/edit.png' border='0'></a>
&nbsp;
<a href='$cgi_url/sched_manage_host.cgi?host=$hn;ip=$ip;action=Del'><img src='/sched/img/trashcan_empty.png' border='0'></a>
</td>
</tr>\n" ;
    }
    print "</table>\n" ;


}

=head1 FUNCTION SchedView::Display::registered_job

    This function display registered job with filter (job, job_re)

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::registered_job(job => 'jobname',
					dbh  => $dbh) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL
 o job : jobname
 o offset : offset

=cut

sub registered_job
{
    my %arg = @_ ;
    my $job  = $arg{job}   || '' ;
    my ($offset, $limit) = get_offset_limit(%arg) ;
    my $dbh = $arg{dbh} ;

    my $q ; 
    my @sql_arg = () ;

    if ($job =~ /^$Sched::re_jobid$/) {
	$q = 'select_registered_job_by_id' ;
	push @sql_arg, $1 ;
    } else {
	$q = 'select_registered_job' ;
    }
    
    push @sql_arg, $offset, $limit ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    print '
<table class="status">
<tr>
<th CLASS="status">Job&nbsp;</th>
<th CLASS="status">Host&nbsp;</th>
<th CLASS="status">Commit date&nbsp;</th>
<th CLASS="status">Release note&nbsp;</th>
</tr>
' ;
    my $c="Odd" ;

    while (my ($job_no,$host,$id,$date,$comm)=$q->fetchrow_array())
    {
	my @hs = split(/,/, $host) ;
	$c = ($c eq "Odd")?'Even':'Odd' ;
	print "
<tr>
<td align='left' valign='center' class='status$c'>
<a href='$cgi_url/sched_list_finish_job.cgi?job=$id'>$id</a></td>
<td align='left' valign='center' class='status$c'>
" ;

	for my $h (@hs) {
	    print "<a href='$cgi_url/sched_list_finish_job.cgi?host=$h\&job=$id'>$h</a> " ;
	}
print "
<td align='left' valign='center' class='status$c'>$date</td>
<td align='left' valign='center' class='status$c'>$comm</td>
</tr>\n" ;
}
    print "</table>\n" ;


}


=head1 FUNCTION SchedView::Display::finish_job

    This function display job with filter (job, host, status)
    Job must have end_date

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::finish_job(host => 'hostname',
				    job  => 'jobname',
				    status => 1,
				    dbh  => $dbh) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL
 o job : job_id
 o host : hostname
 o status : 1 only CRITICAL event

=cut

sub finish_job
{
    my %arg = @_ ;

    my $host = $arg{host}  || '' ;
    my $job  = $arg{job}   || '' ;
    my $crit = $arg{status} || '' ;

    my ($offset, $limit) = get_offset_limit(%arg) ;

    my $host_re = $arg{host_re}  || '' ;

    $host  = undef if ($host !~ /^$Sched::re_host$/) ;
    $job   = undef if ($job  !~ /^$Sched::re_jobid$/) ;
    $crit  = undef if ($crit !~ /^\d$/) ;

    my $dbh = $arg{dbh} ;

    my $q ;
    my @sql_arg = ();

    if ($host and $job) {
	$q = 'select_by_job_and_host' ;
	push @sql_arg, ($job, $host) ;
    } elsif ($host) {
	$q = 'select_by_host' ;
	push @sql_arg, $host ;
    } elsif ($job) {
	$q = 'select_by_job' ;
	push @sql_arg, $job ;
    } elsif ($host_re) {
	$q = 'select_by_host_re' ;
	push @sql_arg, $host_re ;
    } else {
	$q = 'select_all' ;
    }

    push @sql_arg, $offset, $limit ;
    
    if ($crit) {
	$q = "${q}_critical" ;
    }
    
    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    print '
<table class="status">
<tr>
<th CLASS="status">Host&nbsp;</th>
<th CLASS="status">Job&nbsp;</th>
<th CLASS="status">Start date&nbsp;</th>
<th CLASS="status">Running time&nbsp;</th>
<th CLASS="status">Status&nbsp;</th>
<th CLASS="status">Information&nbsp;</th>
</tr>
' ;
    my $c="Odd" ;

    while (my ($job_sid,$start_date,$host,$id,$status,$rtime)=$q->fetchrow_array())
    {
	$status = ($status == 0)?'OK':'CRITICAL';
	$c = ($c eq "Odd")?'Even':'Odd' ;
	print "
<tr>
<td align='left' valign='center' class='status$c'>
<a href='$cgi_url/sched_list_finish_job.cgi?host=$host'>$host</a></td>
<td align='left' valign='center' class='status$c'>
<a href='$cgi_url/sched_list_finish_job.cgi?job=$id'>$id</a></td>
<td align='left' valign='center' class='status$c'>$start_date</td>
<td align='center' valign='center' class='status$c'>$rtime</td>
<td align='center' valign='center' class='status$status'> $status </td>
<td align='right' valign='center' class='status$c'><a style='text-decoration: none;' href='$cgi_url/sched_get_view.cgi?sid=$job_sid'><img border='0' src='/sched/img/status3.png'></a></td>
</tr>\n" ;
}
    print "</table>\n" ;

}

sub add_next_prev
{
    my $q = new CGI ;

    my $offset = $q->param('offset') || 0 ;
    my $limit  = $q->param('limit')  || $default_limit ;

    ($offset, $limit) = get_offset_limit(offset => $offset, limit => $limit) ;

    if (($offset - $limit) >= 0) {
	$q->param('offset', $offset - $limit) ;
	print "<a href='" . $q->url(-absolute=>0,
				    -query=>1) . "'><img src='/sched/img/1leftarrow.png' border='0' /></a>\&nbsp;";
    }

    $q->param('offset', $offset + $limit) ;
    print "<a href='" . $q->url(-absolute=>0,
				-query=>1) . "'><img src='/sched/img/1rightarrow.png' border='0' /></a>";
}

=head1 FUNCTION SchedView::Display::edit_host

    This function display form to edit host 

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::edit_host( host => "host",
				   ip   => "127.0.0.1",
                                   dbh  => $dbh ) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

 o host : (str) hostg name
 o ip   : (str) host address

  or

 o host_no : (id) host id

    OPTIONAL
    

=cut

sub edit_host
{
    my %arg = @_ ;

    my ($info, $online) ;
    my $host_no = $arg{host_no} || ''  ;
    my $host = $arg{host} || '' ;
    my $ip   = $arg{ip} || ''  ;

    my $dbh  = $arg{dbh} ;

    if ($host =~ /^([\w\d\._]+)$/) {
	$host = $1 ;
    } else {
	$host = undef ;
    }
    
    if ($ip =~ /^$Sched::re_ip$/) {
	$ip = $1 ;
    } else {
	$ip = undef ;
    }

     if ($host_no =~ /^(\d+)$/) {
	$host_no = $1 ;
    } else {
	$host_no = undef ;
    }
   
    my $q ;
    my @sql_arg = ();

    if ($host and $ip) {
	$q = "select_host_by_name_ip" ;
	push @sql_arg, ($host,$ip) ;
    } elsif ($host_no) {
	$q = "select_host_by_host_no" ;
	push @sql_arg, ($host_no) ;
    } else {
	print "E : Error in parameters (select_host)" ;
	return ;
    }

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    ($ip,$host,$info,$online)=$q->fetchrow_array() ;
    return unless (defined $host) ;

    print 
	"<table><td class='NavBarItem'>",
	CGI::p("Hostname :"),
	CGI::textfield(-name=>'host',
		       -size=>16,
		       -default=>$host),
	CGI::br(),
	CGI::p("Ip :"),
	CGI::textfield(-name=>'ip',
		       -size=>16,
		       -default=>$ip),
	"</td><td width='50px'>&nbsp;</td><td class='NavBarItem'>",
        CGI::p("Groups :"),
	"<select name='group' size='5' multiple>" ;
    
    @sql_arg = ();
    
    if ($host and $ip) {
	$q = "list_hostgroup_by_name_ip" ;
	push @sql_arg, ($host, $ip) ;
    } elsif ($host_no) {
	$q = "list_hostgroup_by_host_no" ;
	push @sql_arg, ($host_no) ;
    } else {
	print "E : Error in parameters (list_hostgroup)" ;
	return ;
    }

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ; 
   
    while (my ($hostgroup_name, $hostgroup_info, $host_no2) = 
	                   $q->fetchrow_array())
    {
	my $chk = (defined $host_no2)?'selected':'' ;
	print "<option value='$hostgroup_name' $chk>$hostgroup_name</option>\n" ;
    }

    print
	"</select></td></tr></table>",
	CGI::br(),
	CGI::p("Info :"),
	CGI::textarea(-name=>'info',
		      -rows=>5,
		      -columns=>50,
		      -default=>$info),
        CGI::br(),
	CGI::submit(-name=>'action', value => 'Modify') ;
}

=head1 FUNCTION SchedView::Display::add_host

    This function display form to add host 

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::add_host( dbh  => $dbh ) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL

=cut

sub add_host
{
    my %arg = @_ ;

    my $dbh  = $arg{dbh} ;

    print 
	"<table><td class='NavBarItem'>",
	CGI::p("Hostname :"),
	CGI::textfield(-name=>'host',
		       -size=>16),
	CGI::br(),
	CGI::p("Ip :"),
	CGI::textfield(-name=>'ip',
		       -size=>16),
	"</td><td width='50px'>&nbsp;</td><td class='NavBarItem'>",
        CGI::p("Groups :"),
	"<select name='group' size='5' multiple>" ;
    
    my $q = "list_hostgroup" ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute() ;    
   
    while (my ($hostgroup_name, $hostgroup_info) = $q->fetchrow_array())
    {
       my $chk = ($hostgroup_name eq 'all')?'selected':'' ;
       print "<option value='$hostgroup_name' $chk>$hostgroup_name</option>\n";
    }

    print
	"</select></td></tr></table>",
	CGI::br(),
	CGI::p("Info :"),
	CGI::textarea(-name=>'info',
		      -rows=>5,
		      -columns=>50),
        CGI::br(),
	CGI::submit(-name=>'action', -value=>'Add') ;
}

=head1 FUNCTION SchedView::Display::edit_hostgroup

    This function display form to edit hostgroup 

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::edit_hostgroup( hostgroup => "hostgroup",
                                        dbh  => $dbh ) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

 o hostgroup : (str) hostgroup name
   or
 o hostgroup_no : (id) hostgroup id

    OPTIONAL
    
=cut

sub edit_hostgroup
{
    my %arg = @_ ;

    my ($info) ;
    my $hostgroup_no = $arg{hostgroup_no} || ''  ;
    my $hostgroup = $arg{hostgroup} || '' ;

    my $dbh  = $arg{dbh} ;

    if ($hostgroup =~ /^([\w\d\._]+)$/) {
	$hostgroup = $1 ;
    } else {
	$hostgroup = undef ;
    }
    
    if ($hostgroup_no =~ /^(\d+)$/) {
	$hostgroup_no = $1 ;
    } else {
	$hostgroup_no = undef ;
    }
   
    my $q ;
    my @sql_arg = ();

    if ($hostgroup) {
	$q = "select_hostgroup_by_name" ;
	push @sql_arg, ($hostgroup) ;
    } elsif ($hostgroup_no) {
	$q = "select_hostgroup_by_hostgroup_no" ;
	push @sql_arg, ($hostgroup_no) ;
    } else {
	print "E : Error in parameters (select_hostgroup)" ;
	return ;
    }

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    ($hostgroup_no,$hostgroup,$info)=$q->fetchrow_array() ;
    return unless (defined $hostgroup) ;

    $Sched::log->write("hostgroup_no = $hostgroup_no ; hostgroup = $hostgroup ; info = $info") ;

    print 
	"<table><td class='NavBarItem'>",
	CGI::p("Hostgroup name :"),
	CGI::textfield(-name=>'hostgroup',
		       -size=>16,
		       -default=>$hostgroup),
	CGI::br(),
	"</td><td width='50px'>&nbsp;</td><td class='NavBarItem'>",
        CGI::p("Members :"),
	"<select name='host' size='5' multiple>" ;
    
    @sql_arg = ();
    
    $q = "list_host_by_hostgroup_no" ;

    $Sched::log->write("hostgroup_no : $hostgroup_no") ;

    push @sql_arg, ($hostgroup_no) ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;    
   
    while (my ($host, $ip, $hostgroup_no2) = $q->fetchrow_array())
    {
	my $chk = $hostgroup_no2?'selected':'' ;
	print "<option value='$host $ip' $chk>$host $ip</option>\n" ;
    }

    print
	"</select></td></tr></table>",
	CGI::br(),
	CGI::p("Info :"),
	CGI::textarea(-name=>'info',
		      -rows=>5,
		      -columns=>50,
		      -default=>$info),
        CGI::br(),
	CGI::submit(-name=>'action', value => 'Modify') ;
}


=head1 FUNCTION SchedView::Display::add_hostgroup

    This function display form to add hostgroup 

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::add_hostgroup( dbh  => $dbh ) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL

=cut


sub add_hostgroup
{
    my %arg = @_ ;

    my $dbh  = $arg{dbh} ;

    print 
	"<table><td class='NavBarItem'>",
	CGI::p("Hostgroup :"),
	CGI::textfield(-name=>'hostgroup',
		       -size=>16),
	CGI::br(),
	"</td><td width='50px'>&nbsp;</td><td class='NavBarItem'>",
        CGI::p("Hosts :"),
	"<select name='host' size='5' multiple>" ;
    
    my $q = "list_all_host" ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute() ;    
   
    while (my ($host, $ip) = $q->fetchrow_array())
    {
       print "<option value='$host $ip'>$host $ip</option>\n";
    }

    print
	"</select></td></tr></table>",
	CGI::br(),
	CGI::p("Info :"),
	CGI::textarea(-name=>'info',
		      -rows=>5,
		      -columns=>50),
        CGI::br(),
	CGI::submit(-name=>'action', -value=>'Add') ;
}



=head1 FUNCTION SchedView::Display::list_hostgroup

    This function display hostgroup with filter (hostgrou_name)

=head2 USAGE
    
    print CGI::header('text/html') ;
    print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

    SchedView::Display::list_hostgroup(hostgroup => 'hostgroup',
				       dbh  => $dbh) ;

    print CGI::end_html() ;

=head2 ARGUMENTS

 o dbh  : DBI->connect

    OPTIONAL
 o hostgroup_re : hostgroup regexp
 o hostgrou : hostgroup
 o offset : nb
 o limit : nb

=cut

sub list_hostgroup
{
    my %arg = @_ ;

    my $hostgroup = $arg{hostgroup} || '' ;

    my $hostgroup_re = $arg{hostname_re} || '' ;

    my ($offset, $limit) = get_offset_limit(%arg) ;

    my $q ; 
    my @sql_arg = () ;

    if ($hostgroup) {
	$q = 'select_hostgroup_by_name' ;
	push @sql_arg, $hostgroup ;
    } elsif ($hostgroup_re) {
	$q = 'select_hostgroup_by_name_re' ;
	push @sql_arg, $hostgroup_re, $offset, $limit ;
    } else {
	$q = 'select_hostgroup' ;
	push @sql_arg, $offset, $limit ;
    }

    my $dbh = $arg{dbh} ;

    $q = $dbh->prepare($req{$q}) ;
    $q->execute(@sql_arg) ;

    print '
<table class="status">
<tr>
<th CLASS="status">Hostgroup&nbsp;</th>
<th CLASS="status">Information&nbsp;</th>
<th CLASS="status">Options&nbsp;</th>
</tr>
' ;
    my $c="Odd" ;

    while (my ($id,$hg,$info)=$q->fetchrow_array())
    {
	$c = ($c eq "Odd")?'Even':'Odd' ;

	print "
<tr>
<td align='left' valign='center' class='status$c'>$hg</td>
<td align='left' valign='center' class='status$c'>$info</td>
<td align='left' valign='center' class='status$c'>
<a href='$cgi_url/sched_manage_hostgroup.cgi?hostgroup=$hg;action=Edit'><img src='/sched/img/edit.png' border='0'></a>
&nbsp;
<a href='$cgi_url/sched_manage_hostgroup.cgi?hostgroup=$hg;action=Del'><img src='/sched/img/trashcan_empty.png' border='0'></a>
</td>
</tr>\n" ;
    }
    print "</table>\n" ;

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut
