#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;

use SchedView::IHM ;
use SchedView::Display ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}

sub add
{
    my ($hostgroup, $info) = @_ ;

    $dbh->begin_work() ;

    my $sth = $dbh->prepare('
INSERT INTO hostgroup (name,info) 
VALUES (?,?)') ;

    if ($sth->execute($hostgroup, $info)) {
	print "Ok" ;
    } else {
	print "E : ", $sth->errstr ;
	return ;
    }

    add_host($hostgroup) ;

    $dbh->commit() ;
}

sub get_hostgroup_id
{
    my ($hostgroup) = @_ ;

    my $sth = $dbh->prepare('
SELECT hostgroup_no 
FROM hostgroup
WHERE name = ?
') ;

    $sth->execute($hostgroup) ;

    my ($id) = $sth->fetchrow_array() ;
    
    return $id ;
}

sub add_host
{
    my ($hostgroup, $id) = @_ ;

    $id = $id || get_hostgroup_id($hostgroup) ;

    for my $h (CGI::param('host')) {
	next if ($h !~ /^$Sched::re_host $Sched::re_ip$/) ;

	my $sth = $dbh->prepare('
INSERT INTO hostgroup_member (hostgroup_no, host_no) VALUES (?, 
	(SELECT host_no FROM host WHERE name = ? and ip = ?) )
') ;
	$sth->execute($id, $1, $2) || return ;
    }   
}

sub modify
{
    my ($hostgroup, $info) = @_ ;

    $dbh->begin_work() ;
	
    my $old_name = CGI::param('old_hostgroup') || '' ;
    
    if ($old_name =~ /^([\w\d+\._-]+)$/) {
	$old_name = $1 ;
    } else {
	print "E : Old Hostgroup invalid" ;
	return ;
    }
    
    my $sth = $dbh->prepare("
UPDATE hostgroup SET name = ?, info = ? 
WHERE  name = ?
") ;
    if ($sth->execute($hostgroup, $info, $old_name)) {
	print "Ok" ;
    } else {
	print "E : ", $sth->errstr ;
	return ;
    }

    my $id = get_hostgroup_id($hostgroup) ;

    $sth = $dbh->prepare("
DELETE FROM hostgroup_member 
WHERE hostgroup_no = ?
");
    $sth->execute($id) || return ;

    add_host($hostgroup, $id) ;

    $dbh->commit() ;
}

sub edit
{
    my ($hostgroup) = @_ ;

    print CGI::start_form(-methode => 'GET') ;
    $Sched::log->write("hostgroup = $hostgroup") ;
    SchedView::Display::edit_hostgroup(hostgroup => $hostgroup, 
				       dbh => $dbh) ;
    
    print CGI::hidden(-name => 'old_hostgroup',
		      -default => $hostgroup) ;
    
    print CGI::end_form() ;

}

sub delete_hostgroup
{
    my ($hostgroup) = @_ ;
    
    my $sth = $dbh->prepare("
DELETE FROM hostgroup
WHERE  name = ? 
") ;
    if ($sth->execute($hostgroup)) {
	print "Delete $hostgroup : Ok" ;
    } else {
	print "E : ", $sth->errstr ;
    }
}

print CGI::header('text/html') ;
#print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

SchedView::IHM::insert_begin('Manage Hostgroup') ;
SchedView::IHM::insert_title('Manage Hostgroup') ;

print "<td>\n" ;

if (CGI::param()) {
    my $action = CGI::param('action')  || '';

    my $info = CGI::param('info') || 'No comment' ;
    $info =~ s/'";/ /g ; # '
    $info =~ /^(.+)$/ ;
    $info = $1 ;
    
    my $hostgroup = CGI::param('hostgroup') || '' ;
	
    if ($hostgroup =~ /^([\w\d+\._-]+)$/) {
	$hostgroup = $1 ;
    } else {
	print "E : Hostgroup invalid" ;
	exit 0 ;
    }
	    
    if ($action eq 'Add') {
	add($hostgroup, $info) ;
	print "<br/><a href='javascript:window.history.go(-2)'> Back </a>" ;
    } elsif ($action eq 'Modify') {
	modify($hostgroup, $info) ;
	edit($hostgroup) ;
    } elsif ($action eq 'Del') {
	print CGI::start_form() ;
	print
	   CGI::p("Do you realy want to delete $hostgroup ?"),
	   CGI::hidden(-name => "hostgroup", -value => $hostgroup),
	   CGI::submit(-name => "action", -value => "Delete") ;
	print CGI::end_form() ;
    } elsif ($action eq 'Delete') {
   	delete_hostgroup($hostgroup) ; 
	print "<br/><a href='javascript:window.history.go(-2)'> Back </a>" ;
    } else {
	edit($hostgroup) ;
    }

} else {
    print CGI::start_form() ;
    SchedView::Display::add_hostgroup(dbh => $dbh) ;
    print CGI::end_form() ;
}

print "</td>\n" ;
SchedView::IHM::insert_end() ;

#print CGI::end_html() ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

