#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;

use SchedView::IHM ;
use SchedView::Display ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;
my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    print "E : erreur de connexion\n" ;
    return 0 ;
}

print CGI::header('text/html') ;
#print CGI::start_html(-style=>{'src'=>'/sched/style.css'}) ;

SchedView::IHM::insert_begin('Groups') ;
SchedView::IHM::insert_title('Hostgroup list') ;

print "<tr><td><br/>" ;
SchedView::IHM::insert_box('Add Hostgroup', 
			   "$SchedView::IHM::C/sched_manage_hostgroup.cgi") ;
print "<br/></td></tr>" ;

SchedView::Display::list_hostgroup(hostgroup  => CGI::param('hostgroup') || '',
				   offset => CGI::param('offset') || 0,
				   limit  => CGI::param('limit')  || 10,
				   dbh  => $dbh) ;

SchedView::Display::add_next_prev() ;

SchedView::IHM::insert_end() ;
#print CGI::end_html() ;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

