#!/usr/bin/perl -w
use strict ;

use CGI ;
use DBI ;

die "E : initialisation impossible" if (!CGI::param()) ;

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;

my $sid = CGI::param('sid') ;

my $re_sid = '^([\w\d\.-]+:[\w\d\.-]+:[\w\d\.-]+)$' ;
my $re_id = '^([\w\d\.-]+)$' ;

if ($sid !~ $re_sid) { 
    $Sched::log->write("E : erreur de sid") ;
    exit 0 ;
}
$sid = $1 ;

sub job_action
{
    use Net::EasyTCP ;

    my ($sid, $action) = @_ ;
    my $master = new Net::EasyTCP(mode =>      'client',
			       host => Sched::cfg('master_ip'),
			       port => Sched::cfg('master_port'),
			       password => Sched::cfg('master_passwd'),
			       );

    if (!$master) {
	$Sched::log->write("E : erreur de connexion sur le master $@") ;
	return 0 ;
    }
    my $mdp = Sched::cfg('view_passwd') ;
    $master->send("EHLO $mdp") ;

    my $rep = $master->receive(5) ;

    if ($rep eq 'OK') {
	$Sched::log->write("I : connexion reussi", 10) ;
    } else {
	$Sched::log->write("E : connexion refusee $@") ;
	$master->close() ;
	return 0 ;
    }
    if ($action eq "update") {
        $master->send("UPDATE $sid") ;
    } elsif ($action eq "cancel") {
	my $t = CGI::param("id") || '';
	if ($t =~ $re_id) {
	   $t = $1 ; 
	   $master->send("CANCEL $sid:$t") ;
	} else {
	   $Sched::log->write("E : CANCEL id invalide") ;
	}
    } elsif ($action eq "canceljob") {
        $master->send("CANCELJOB $sid") ;
    } elsif ($action eq "watch") {
        $master->send("WATCH $sid") ;
    } else {
        $Sched::log->write("E : action invalide") ;
    }
    $master->send("QUIT") ;
    $master->close() ;

    print CGI::header(-type=>'text/plain') ;
    print "OK" ;
}


sub send_status
{
	my ($sid) = @_ ;
	my $dsn = Sched::cfg('dsn') ;
	# postgresql
	my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

	if (!$dbh)
	{
	    print "E : erreur de connexion\n" ;
	    return 0 ;
	}

	my $q = $dbh->prepare('SELECT xml FROM job_hist WHERE job_sid=?') ;
	$q->execute($sid) ;

	my ($r) = $q->fetchrow_array() ;

	print CGI::header(-type=>'text/xml') ;
	print '<?xml version="1.0"?>';
	print $r ;
}

if (CGI::param('action')) {
    job_action($sid, CGI::param('action')) ;
} else {
    send_status($sid) ;
}

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

