#!/usr/bin/perl -w 
use strict ;

=head1 CGI sched_get_log.cgi

    Ce programme permet de recuperer la sortie d'une tache (stderr, stdout)

=cut

use CGI ;
use DBI ;

die "E : initialisation impossible" if (!CGI::param()) ;

##########################################################

use Sched ;
Sched::init('cgi', "$Sched::prefix_etc/cgi.cfg") ;

##########################################################

print CGI::header('text/plain') ;

my $re_sid = '^(([\w\d\.-]+):[\w\d\.-]+:[\w\d\.-]+)$' ;
my $re_id = '^([\w\d\.-]+)$' ;
my $re_log = '^(stderr|stdout)$' ;

my $sid = CGI::param('sid') || '' ;

if ($sid !~ $re_sid) { 
    $Sched::log->write("E : error on sid") ;
    print "E : error on sid" ;
    exit 0 ;
}

$sid = $1 ;
my $serial = $2 ;

my $task = CGI::param('task') || '';

if ($task !~ $re_id) {
    $Sched::log->write("E : error on task id") ;
    print "E : error on task id" ;
    exit 0 ;
}

$task = $1 ;

my $log = CGI::param('log') || '';

if ($log !~ $re_log) {
    $Sched::log->write("E : error on log file name") ;
    print "E : error on log file name" ;
    exit 0 ;
}

$log = $1 ;

##########################################################

my $dsn = Sched::cfg('dsn') ;

# postgresql
my $dbh = DBI->connect("DBI:Pg:$dsn",'', '');

if (!$dbh)
{
    $Sched::log->write("E : error of connection ($dbh->errstr)") ;
    print "E : can't connect to database" ;
    return 0 ;
}


##########################################################

use Sched::Job ;
use Sched::Cmd ;
use XML::Mini::Document ;

my $req = '
SELECT xml,host
FROM job_hist
WHERE job_sid = ?
' ;

my $sth = $dbh->prepare($req) ;
$sth->execute($sid) ;

my ($xml, $host) = $sth->fetchrow_array() ; $sth = undef ;

if (!$xml) {
    $Sched::log->write("E :  $sid isn't in database (update status first ?)") ;
    print "E : $sid isn't in database (update status first ?)" ; 
    exit 0 ;
}

# pour valoriser ${HOSTNAME}
$Sched::hostname = $host ;

my $doc = XML::Mini::Document->new() ;
$doc->parse($xml) ;
if (!$doc) {
    $Sched::log->write("E : error while loading $sid status") ;
    print "E : error while loading $sid status" ;
    exit 0 ;
}

$xml = $doc->getRoot()->getElement('job') ;
my $job = new Sched::Job(xml => $xml,
			 serial => $xml->attribute('serial')) ;

my $cmd = Sched::Cmd::find_task_by_id($xml, $task) ;

if (!$cmd) {
    $Sched::log->write("E : error while loading $sid:$task status") ;
    print "E : error while loading $sid:$task status" ;
    exit 0 ;
}

my $file = $cmd->attribute($log) ;

if ($file =~ /^[^\w\d\.-]+$/) {
    $Sched::log->write("E : error $sid:$task:$log ($file) isn't valid") ;
    print "E : error $sid:$task:$log ($file) isn't valid" ;
    exit 0 ;
}

my $target = $cmd->attribute('host') || $host ;
$req = "
SELECT ip
FROM host
WHERE name = ?
" ;

$sth = $dbh->prepare($req) ;
$sth->execute($target) ;

my ($ip) = $sth->fetchrow_array() ; $sth = undef ;

if (!$ip) {
    $Sched::log->write("E : Can't get ip from $target") ;
    print "E : error in getting ip attribute from $target" ;
    exit 0 ;
}

$dbh->disconnect() ;

print "Content of $sid:$task:$file :\n" ;

my $xfer_port = Sched::cfg('xfer_port') || 5545 ;

system('wget',
       '-q',
       '-O','/dev/stdout', 
       "http://$ip:$xfer_port/sched_job_dir/$serial/$file") ;

if ($?) {
    print "E : can't load file... sched_xfer not running ? or file doesn't exist" ; 
}

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

