/*
 * Part of the network scheduling system (Sched)
 * Copyright (C) 2004-2005 Eric Bollengier
 *     All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

 var xmlDoc ;
 var actionDoc ;

 var url='/cgi-bin/sched/sched_get_status.cgi?sid=' ;
 var my_url='/cgi-bin/sched/sched_get_view.cgi?sid=' ;
 var log_url='/cgi-bin/sched/sched_get_log.cgi?sid=' ;

 var job_sid ;
 var svg_element ;
 var reload_timeout=20 ;    // rechargement du XML toutes les 20s
 var timeout_id ;

 var svg_width = 800 ;
 var svg_heigh = 600 ;

function get_min_max_pos(xml, pos)
{
    var xmin = 0 ;
    var xmax = 1 ;
    var ymin = 2 ;
    var ymax = 3 ;

    if (!xml) {
	return (pos) ;
    }

    var children = xml.childNodes ;

    for (var i=0;i<children.length;i++)
    {
	var child = children[i] ;
	if (child.nodeType == 1) {
		if (child.getAttribute("x") 
		    &&
		    child.getAttribute("y")) 
		{
		    var x = parseInt(child.getAttribute("x")) ;
		    var y = parseInt(child.getAttribute("y")) ;
		    
		    if (x < pos[xmin]) {
			pos[xmin] = x ;
		    } else if (x > pos[xmax]) {
			pos[xmax] = x ;
		    }
		
		    if (y < pos[ymin]) {
			pos[ymin] = y ;
		    } else if (y > pos[ymax]) {
			pos[ymax] = y ;
		    }
		    
		    pos = get_min_max_pos(child, pos) ;
		}
	}
    }

    return (pos) ;
}

function on_zoom_show_all()
{
    var xmin = 0 ;
    var xmax = 1 ;
    var ymin = 2 ;
    var ymax = 3 ;

    var xml = xmlDoc.getElementsByTagName('job');

    if (!xml.length) {
	window.status = "E : Impossible de zoomer " + url ;
	return ;
    }
    // calcul de la taille maxi des objets
    var pos = get_min_max_pos(xml[0], Array(0,0,0,0) ) ;

    // calcul du zoom pour tout afficher sur x puis sur y
    var zoom_y =  svg_heigh / (pos[ymax] + 60 - pos[ymin] + 30) ;
    var zoom_x =  svg_width / (pos[xmax] + 100  - pos[xmin] + 30) ;

    // on prend le plus gros (pour etre sur de tout afficher)
    var zoom = (zoom_x < zoom_y) ? zoom_x : zoom_y ;

    var xform = document.getElementById('_svgdoc').createSVGTransform();
    xform.setScale(zoom, zoom);
    var id = svg_element.suspendRedraw(0);
    transform_list.clear() ;
    transform_list.appendItem(xform);
    svg_element.unsuspendRedraw(id); 

}

/***************************************************
 * fonction appelee au chargement de la vue
 ***************************************************/

 function init(sid)
 {

    if (!sid) {
        alert("Initialisation impossible") ;
	return ;
    }

    job_sid = sid ;    
    url = url + sid ;

    xmlDoc = document.implementation.createDocument("","test",null);
    xmlDoc.addEventListener("load", documentLoaded, false);

    actionDoc = document.implementation.createDocument("","test",null);
    actionDoc.addEventListener("load", actionLoaded, false);

    on_update_timer() ;

    /***************************************************
     * initialisation des events sur les "boites" svg
     ***************************************************/

    var grp = document.getElementById('_task').getElementsByTagName('rect');
    for (i=0;i<grp.length;i++) {
	var g = grp[i] ;
	g.addEventListener("click", mouseclick_listener, false) ;
    }

    // pour avoir du zoom
    transform_list = document.getElementById('_all').transform.baseVal;
    svg_element = document.getElementById('_all').ownerSVGElement;
 }	    

 function set_update()
 {
     timeout_id = setTimeout("on_update_timer()",reload_timeout * 1000) ;
 }

 function cancel_timeout()
 {
     clearTimeout(timeout_id);
 }

 function on_update_timer()
 {
	on_update(null) ;
	set_update() ;
 }

 function get_log(logtype)
 {
     var id = document.getElementById('_id').value ;
     var url = log_url + job_sid + ';task=' + id + ';log=' + logtype ;
     
     window.open(url);
 }

/***************************************************
 * fonction qui renvoie 1 si le job est en cours
 ***************************************************/
 function is_running()
 {
    if (! xmlDoc) {
	return 1 ;
    }

    var job = xmlDoc.getElementsByTagName('job') ;
    
    if (! job[0] ) {
	return 1 ;
    }

    if (   (! job[0].getAttribute('state')) 
       || (job[0].getAttribute('state') == "running") 
        ) 
    {
       return 1 ; 
    } else {
       return 0 ;
    }

 }

/***************************************************
 * fonction callback du bp Update 
 ***************************************************/

 function on_update(evt)
 {
    if (!is_running()) {
	cancel_timeout() ;
    }  
    xmlDoc.load(url) ;
 }

/***************************************************
 * fonction callback du bp Update Status
 ***************************************************/

 function on_update_status(evt)
 {
    if (is_running()) {
       actionDoc.load(url + ";action=update") ;
    }
 }

/***************************************************
 * fonction callback du bp Auto Update
 ***************************************************/

 function on_auto_update(evt)
 {
    if (!is_running()) {
       return ;
    }
    actionDoc.load(url + ";action=watch") ;
    if (document.getElementById('_watch').getAttribute("checked") == "true") {
      document.getElementById('_watch').setAttribute("checked", "false") ;
    } else {
      document.getElementById('_watch').setAttribute("checked", "true") ;
    }
 }

 function on_cancel_job(evt)
 {
    if (is_running()) {
       actionDoc.load(url + ";action=canceljob") ;
    }
 }

 function on_cancel(evt)
 {
    if (is_running()) {
        var id ;
        id = document.getElementById('_id').value
	if (id) {
            actionDoc.load(url + ";action=cancel;id=" + id) ;
	}
    }
 }


 function actionLoaded(e)
 {
    window.status = "I : Order send to master" ;
 }

 function getTaskById(root,id)
 {

// TODO : indiquer dans le fichier XML que id est un ID !

    var job = root.getElementsByTagName('job') ;
    if (job[0].getAttribute('id') == id) {
	return job[0] ;
    }

    var task = root.getElementsByTagName('task') ;

    for (i=0;i<task.length;i++) {
	if(task[i].getAttribute('id') == id) {
		return task[i] ;
	}
    }

    return null ;
 }


 function update(nodes)
 {
    for (i=0;i<nodes.length;i++) {
	var item = nodes[i] ;
	var id = item.getAttribute('id') ;
	var rec = document.getElementById(id) ;

	if (!rec) {
	    continue ;
	}

	var state = item.getAttribute('state') ;

	if (state) {
	    if (state == 'finish') {
		var color ;
		var status = item.getAttribute('status') ;
		if (status == 0) {
		    color = 'green' ;
		} else {
		    color = 'red' ;
		}
                rec.setAttribute('style',
	    'opacity: 0.5; fill: ' + color + '; fill-opacity: 0.5') ;
	    } 

	    if (state == 'failed') {
                rec.setAttribute('style',
	    'opacity: 0.5; fill: orange; fill-opacity: 0.5') ;
	    }

	    if (state == 'running') {
                rec.setAttribute('style',
	    'opacity: 0.5; fill: blue; fill-opacity: 0.5') ;

	    } 

	    if (state == 'kill') {
                rec.setAttribute('style',
	    'opacity: 0.5; fill: salmon; fill-opacity: 0.5') ;

	    } 
	}
    }

 }

/***************************************************
 * fonction callback quand le document est arrive
 ***************************************************/

 function documentLoaded(e)
 {
    // [<job>]
    var x = xmlDoc.getElementsByTagName('job');
    if (!x.length) {
	window.status = "E : Impossible de charger " + url ;
	return ;
    }
    update(x) ;

    x = x[0] ; // on prend le premier <job> (y'en a qu'un)

    if (x.getAttribute('state') == "finish") {
	reload_timeout = 300 ;
    }

    // Date utilise les millisecondes depuis 1970
    var d = new Date(parseInt(x.getAttribute('sync_date'))*1000) ;

    var sync_date = document.getElementById('_sync_date') ;
    sync_date.value = d.toString() ;


    // [<task>, <task>, <task>...]
    var x = xmlDoc.getElementsByTagName('task');
    update(x) ;
 }

/***************************************************
 * fonction evenement lors du click sur un element
 ***************************************************/

function mouseclick_listener(evt)
{
    var id = evt.target.getAttribute('id') ;
    var task = getTaskById(xmlDoc, id) ;

    var cmdline ;

    if (!task) {
       window.status = "E : pas de " + id ;
       return ;
    }

    /***************************************************
     * Affichage des informations simples
     ***************************************************/

    var tab = new Array('state', 'status', 'id', 'info', 'host',
                        'after_cmd_status', 'stdout', 'stderr',
                        'stdin', 'user', 'group', 'maxtime') ;
    for(i=0; i<tab.length; i++) {

	document.getElementById('_' + tab[i]).value = task.getAttribute(tab[i]) ;
	//document.getElementById('_' + tab[i]).setAttribute('value', task.getAttribute(tab[i])) ;
    }

    /***************************************************
     * Affichage des dates
     ***************************************************/

    var date = new Date(parseInt(task.getAttribute('start_date'))*1000) ;

    var w = document.getElementById('_start_date') ;
    //w.setAttribute('value', date.toString() ) ;
    w.value = date.toString()  ;
 
       /***************************************************
        * Affichage du temps d'execution du task/job
        ***************************************************/

    var end_date ;
    if (task.getAttribute('sync_date')) {
       end_date = task.getAttribute('sync_date') ;
    } else if (task.getAttribute('end_date')) {
       end_date = task.getAttribute('end_date') ;
    } 

    w = document.getElementById('_exec_time') ;

    if (end_date) {
       var separa = parseInt((end_date - task.getAttribute('start_date'))/60);
       w.value = separa + " min" ;
    } else {
       w.value = '' ;   
    }

    /***************************************************
     * Affichage des informations base64
     ***************************************************/
    var cmdline ;

    tab = new Array('comment', 'cond', 'after_cmd', 'cmdline') ;
    for(i=0; i<tab.length; i++) {

    	var txt = task.getAttribute(tab[i]) ;
   	if (txt) {
		txt = decodeBase64(txt) ;

		// pour chercher le sched_job
		if (tab[i] == 'cmdline') {
			cmdline = txt ;
		}		
    	}

    	var textarea = document.getElementById('_' + tab[i]) ;
	// set TEXTAREA !!!
    	textarea.value = txt ;
    }

    /***************************************************
     * permet d'ouvrir la fenetre sur un sous job
     ***************************************************/

    if ((evt.ctrlKey) && (cmdline.search('sched_job') != -1)) {

	// -j /path/to/job.xml
	var re = new RegExp(/-j\s+([\w\d\/\.-]+\/)?([\w\d-]+)\.xml/) ;
	var tab_job = cmdline.match(re) ; // il me faut $2

	// serial:plume:job
	var tab_sid = job_sid.split(/:/) ;
	var host = task.getAttribute('host') ;
	if (!host) {
		host = tab_sid[1] ;
	}

	//                   serial    :    host    : job (re[2])
	if (tab_job) {
          window.open(my_url + tab_sid[0] + ':' + host + ':' + tab_job[2]) ;
	}
    }

}

function scale_in()
{
	var xform = document.getElementById('_svgdoc').createSVGTransform();
	xform.setScale(1.2,1.2);
	var id = svg_element.suspendRedraw(0);
	transform_list.appendItem(xform);
	svg_element.unsuspendRedraw(id); 
}
function scale_out()
{
	var xform = document.getElementById('_svgdoc').createSVGTransform();
	xform.setScale(0.7,0.7);
	var id = svg_element.suspendRedraw(1000);
	transform_list.appendItem(xform);
	svg_element.unsuspendRedraw(id);
}

/****************************************************************
 * JavaScript Encoding/Decoding
 * Written by Stephen Ostermiller
 * Copyright (C) 2003 Stephen Ostermiller
 * http://ostermiller.org/calc/encode.html
 * 
 * Release under GPL
 *****************************************************************/

function urlDecode(str){
    str=str.replace(new RegExp('\+','g'),' ');
    return unescape(str);
}
function urlEncode(str){
    str=escape(str);
    str=str.replace(new RegExp('\+','g'),'%2B');
    return str.replace(new RegExp('%20','g'),'+');
}

var END_OF_INPUT = -1;

var base64Chars = new Array(
    'A','B','C','D','E','F','G','H',
    'I','J','K','L','M','N','O','P',
    'Q','R','S','T','U','V','W','X',
    'Y','Z','a','b','c','d','e','f',
    'g','h','i','j','k','l','m','n',
    'o','p','q','r','s','t','u','v',
    'w','x','y','z','0','1','2','3',
    '4','5','6','7','8','9','+','/'
);

var reverseBase64Chars = new Array();
for (var i=0; i < base64Chars.length; i++){
    reverseBase64Chars[base64Chars[i]] = i;
}

var base64Str;
var base64Count;
function setBase64Str(str){
    base64Str = str;
    base64Count = 0;
}
function readBase64(){    
    if (!base64Str) return END_OF_INPUT;
    if (base64Count >= base64Str.length) return END_OF_INPUT;
    var c = base64Str.charCodeAt(base64Count) & 0xff;
    base64Count++;
    return c;
}
function encodeBase64(str){
    setBase64Str(str);
    var result = '';
    var inBuffer = new Array(3);
    var lineCount = 0;
    var done = false;
    while (!done && (inBuffer[0] = readBase64()) != END_OF_INPUT){
        inBuffer[1] = readBase64();
        inBuffer[2] = readBase64();
        result += (base64Chars[ inBuffer[0] >> 2 ]);
        if (inBuffer[1] != END_OF_INPUT){
            result += (base64Chars [(( inBuffer[0] << 4 ) & 0x30) | (inBuffer[1] >> 4) ]);
            if (inBuffer[2] != END_OF_INPUT){
                result += (base64Chars [((inBuffer[1] << 2) & 0x3c) | (inBuffer[2] >> 6) ]);
                result += (base64Chars [inBuffer[2] & 0x3F]);
            } else {
                result += (base64Chars [((inBuffer[1] << 2) & 0x3c)]);
                result += ('=');
                done = true;
            }
        } else {
            result += (base64Chars [(( inBuffer[0] << 4 ) & 0x30)]);
            result += ('=');
            result += ('=');
            done = true;
        }
        lineCount += 4;
        if (lineCount >= 76){
            result += ('\n');
            lineCount = 0;
        }
    }
    return result;
}
function readReverseBase64(){   
    if (!base64Str) return END_OF_INPUT;
    while (true){      
        if (base64Count >= base64Str.length) return END_OF_INPUT;
        var nextCharacter = base64Str.charAt(base64Count);
        base64Count++;
        if (reverseBase64Chars[nextCharacter]){
            return reverseBase64Chars[nextCharacter];
        }
        if (nextCharacter == 'A') return 0;
    } 
}

function ntos(n){
    n=n.toString(16);
    if (n.length == 1) n="0"+n;
    n="%"+n;
    return unescape(n);
}

function decodeBase64(str){
    setBase64Str(str);
    var result = "";
    var inBuffer = new Array(4);
    var done = false;
    while (!done && (inBuffer[0] = readReverseBase64()) != END_OF_INPUT
        && (inBuffer[1] = readReverseBase64()) != END_OF_INPUT){
        inBuffer[2] = readReverseBase64();
        inBuffer[3] = readReverseBase64();
        result += ntos((((inBuffer[0] << 2) & 0xff)| inBuffer[1] >> 4));
        if (inBuffer[2] != END_OF_INPUT){
            result +=  ntos((((inBuffer[1] << 4) & 0xff)| inBuffer[2] >> 2));
            if (inBuffer[3] != END_OF_INPUT){
                result +=  ntos((((inBuffer[2] << 6)  & 0xff) | inBuffer[3]));
            } else {
                done = true;
            }
        } else {
            done = true;
        }
    }
    return result;
}

var digitArray = new Array('0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f');
function toHex(n){
    var result = ''
    var start = true;
    for (var i=32; i>0;){
        i-=4;
        var digit = (n>>i) & 0xf;
        if (!start || digit != 0){
            start = false;
            result += digitArray[digit];
        }
    }
    return (result==''?'0':result);
}

function pad(str, len, pad){
    var result = str;
    for (var i=str.length; i<len; i++){
        result = pad + result;
    }
    return result;
}

function encodeHex(str){
    var result = "";
    for (var i=0; i<str.length; i++){
        result += pad(toHex(str.charCodeAt(i)&0xff),2,'0');
    }
    return result;
}

function decodeHex(str){
    str = str.replace(new RegExp("s/[^0-9a-zA-Z]//g"));
    var result = "";
    var nextchar = "";
    for (var i=0; i<str.length; i++){
        nextchar += str.charAt(i);
        if (nextchar.length == 2){
            result += ntos(eval('0x'+nextchar));
            nextchar = "";
        }
    }
    return result;
}    
