package Sched::Var ;

use strict ;
use MIME::Base64 ;
use POSIX qw/strftime/ ;

=head1 NAME Sched::Var

Gestion des variables d'un fichier Job
    ${DATE}		20042607
    ${SERIAL}
    ${HOSTNAME}

    ${USER1}  = machine1
    ${MADATE} = %Y%m%J

    ${var1}

    ${ID} = id en cours (task)
    ${JOB} = job en cours

    [A-Za-z0-9_] = .+

=cut

our %var ;
our $version = '$Id: Var.pm,v 1.1 2005/04/05 20:01:49 mcgregor Exp $' ;


my $re_key = '([A-Za-z0-9\._-]+?)' ;

sub init
{
    my ($xml) = @_ ;

    %var = () ;

    return if (not defined $xml) ;


    for my $t (@{ $xml->getAllChildren('var') }) {
	my $k  = $t->attribute('name') ;
	my $v  = $t->attribute('value') ;
	
	$v = MIME::Base64::decode_base64($v) if ($v) ;
	add_var($k, $v) ;
    }    

    add_var('SERIAL', $Sched::serial)     if ($Sched::serial) ;
    add_var('HOSTNAME', $Sched::hostname) if ($Sched::hostname) ;
}

sub add_var
{
    my ($k, $v) = @_ ;

    my $ret = 1 ;

    if (($k =~ /^$re_key$/) and $v) {
	$Sched::log->write("W : warning $k is already defined") 
	    if (exists $var{$k}) ;
	$var{$k} = $v ;
    } else {
	$Sched::log->write("W : warning [$k] isn't a good key") ;
	$ret = 0 ;
    }
    return $ret ;
}

sub del_var
{
 
    my ($k) = @_ ;
    delete $var{$k} ;
}

=head2 FUNCTION Sched::Var::expand

    cette fonction remplace toutes les variables connues
    dans une chaine.

=head3 USAGE

    $Sched::Var::do_strftime = 0 ;

    $str = '${VAR1}' ;
    $str = Sched::Var::expand($str) ;

=cut

our $do_strftime = 1 ; 

sub expand
{
    my ($str) = @_ ;
    my @v ;

    if (@v = ($str =~ /\$\{$re_key\}/ogm)) {
	for my $k (@v) {
	    if (exists $var{$k}) {
		my $val = $var{$k} ;

		$str =~ s/\$\{$k\}/$val/ ;
	    }
	}
    }

    $str = POSIX::strftime($str, localtime(time)) 
	if ($do_strftime) ;

    return $str ;
}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

