use strict ;
package Sched::Timeout ;

=head1 NAME Sched::Timeout

Ce module est utilise pour gerer les timeout des commandes via 
Event(3pm)

=cut

use Event ;

our $version = '$Id: Timeout.pm,v 1.1 2005/04/05 20:01:49 mcgregor Exp $' ;

# cb sur evenement timeout
sub kill_cmd
{
    my ($event) = @_ ;

    my $timer = $event->w ;
    my $id = $timer->data() ;
    my $cmd = Sched::Cmd::get_from_sid($id) ;

    del_timer($id) ;

    if (defined $cmd) {
	$Sched::log->write("D : Cancel de $id", 15) ;
	$cmd->cancel() ;

	add_timer($id, 45) ;
    }
}

=head1 VARIABLE %cmd_maxtime

    liste des timer en cours
    $id => $timer

=cut

my %cmd_maxtime ;	# liste des timer des commandes

=head1 FUNCTION add_timer

Met en place un timer associe a la tache ($id) et lance la procedure
kill_cmd.

=head2 USAGE

 add_timer($id, 120) 

=cut


sub add_timer
{
    my ($id, $after) = @_ ;

    del_timer($id) ;

    return if (!$after) ;

    my $t = Event->timer(after => $after,
			 desc => "maxtime of $id",
			 data => $id,
			 cb => \&kill_cmd,
			 ) ;
    $cmd_maxtime{$id} = $t ;
    $t->start() ;
}

=head1 FUNCTION del_timer

Supprime un timer associ a $id

=head2 USAGE

 del_timer($id) 

=cut

sub del_timer
{
    my $id = shift ;

    my $t = $cmd_maxtime{$id} ;
    if ($t) {
	$t->cancel() ;
	delete $cmd_maxtime{$id} ;
    }
}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

