package Sched::NS ;
use strict ;

our $version = '$Id: NS.pm,v 1.1 2005/04/05 20:01:49 mcgregor Exp $' ;

=head1 PACKAGE Sched::NS

Database convertion between ID and SID

=head1 FUNCTION Sched::NS::set_jobid

Set jobid context execution

=head2 USAGE

SchedUI::NS::set_jobid($id) ;

=head2 TODO

    BUG => attention si id == uid

=cut

my %context ;

my $search ;

sub set_jobid
{
    my ($jobid) = @_ ;

    if (not exists $context{$jobid}) {
	$context{$jobid} = {} ;
    }

    $search = $context{$jobid} ;
}

my $n = 1 ;

sub get_uid
{
    my $str = "tmp-id-$$-$n" ;
    $n++ ;
    return $str ; 
}

=head1 FUNCTION Sched::NS::get_obj

a partir d'un id renvoi un objet (passage par l'uid)

$obj = aa(aa($id)) ;

=cut

sub get_obj
{
    my ($id) = @_ ;
    return aa(aa($id)) ;
}

sub aa
{
    my ($id) = @_ ;

    if (not $id) {
	return undef ;
    }
    return $search->{$id} ;
}

sub rename_jobid
{
    my ($jobid, $newjobid) = @_ ;
    $context{$newjobid} = $context{$jobid} ;
    delete $context{$jobid} ;
}

=head1 FUNCTION Sched::NS::rename_id

Cette fonction permet de renommer un id

=cut

sub rename_id
{
    my ($id, $newid) = @_ ;
    $search->{$newid} = $search->{$id} ;
    delete $search->{$id} ;
}

sub unregister_id
{
    my ($id) = @_ ;
    delete $search->{$id} ;
}

sub register_id
{
    my ($id, $obj) = @_ ;
    $search->{$id} = $obj ;
}


1;
__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

