package Sched::Script ;
use strict ;

=head1 PACKAGE Sched::Script

    Ce package est utilise pour ajouter des fonctions au script (cond et
    after_cmd) par exemple.

=cut

################################################################

=head1 VARIABLE $export_funcs
    
    Ce tableau contien la liste des symboles a exporter.

=head2 USAGE

    $export_funcs = [ qw/&fun1 &fun2 &fun3/ ] ;

=cut

our $export_funcs = [ qw/&testit &mailto/ ] ;

sub testit
{
    return 1;
}

################################################################

=head1 FUNCTION mailto

    Cette fonction permet d'envoyer un mail de rapport

=head2 USAGE

    mailto('email@domain', '[SUBJECT] info', 'mail...') ;

=head2 RETURN

    0 : ERR
    1 : OK
    
=cut

sub mailto
{
    my ($to, $subject, $data) = @_ ;

    if (!$to or !$subject or !$data) {
	print "E : arg error in script mailto\n" ;
	return 0 ;
    }

    open(MAIL, "|mail -s '$subject' $to") ;
    print MAIL $data ;
    close(MAIL) ;

    return 1 ;
}


1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

