package Sched::Callback ;

use strict ;

my %evt_list ;



=head1 FUNCTION Sched::Callback::add_cb

Cette methode ajoute un hook sur un evenement particulier

=head2 USAGE
    
      evt : chaine
      cb  : &fonction callback
      arg : argument passe au callback 

=cut

# add_event('PUT stdout:serial:id', \&Sched::Cmd::run, [$obj]) ;
sub add_cb
{
    my ($evt, $fun, $arg) = @_ ;
    push @{$evt_list{$evt}}, [$fun, $arg] ;
}


=head1 FUNCTION Sched::Callback::del_cb

Cette fonction supprime tous les callback associes a un event (attention)

=cut

sub del_cb
{
    my ($evt) = @_ ;
    delete $evt_list{$evt} ;
}


=head1 FUNCTION Sched::Callback::call_cb

Declenche la totalite les callback enregistrer pour un evenement et
l'efface de la liste des callback

=head2 USAGE

    evt : chaine

=cut

sub call_cb
{
    my ($evt) = @_ ;

    return 1 if (not exists $evt_list{$evt}) ;

    recall_cb($evt) ;

    delete $evt_list{$evt} ;
}

=head1 FUNCTION Sched::Callback::recall_cb

Declenche la totalite les callback enregistrer pour un evenement

=head2 USAGE

    evt : chaine

=cut

sub recall_cb
{
    my ($evt) = @_ ;

    return 1 if (not exists $evt_list{$evt}) ;
    
    for my $l (@{$evt_list{$evt}}) {
	my ($fun, $arg) = @$l ;
	&{$fun}(@{$arg})
    }
}

sub test
{

    &Sched::Callback::add_cb('PUT stdout:serial:id',
			     sub { print @_ },
			     ["hello\n"]) ;

    &Sched::Callback::add_cb('test',
			     sub { print join("\n", @_), "\n" ;},
			     ['toto', 'titi']) ;

    sleep(2) ;
    &Sched::Callback::call_cb('PUT stdout:serial:id') ;
    sleep(2) ;

    &Sched::Callback::call_cb('test') ;

}
1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut
