package Sched ;
use strict ;

use Config::IniFiles ;
use Log::LogLite ;
use POSIX ();

our $cfg ;
our $log ;
our $hostname ;
our $jobid ;
our $job_file ;
our $serial ;
our $type ;

our $sid ;

our $version = '$Id: Sched.pm,v 1.2 2005/04/16 09:59:15 mcgregor Exp $' ;

our $prefix = '' ;
our $prefix_etc = "$prefix/etc/sched" ;
our $prefix_bin = "$prefix/usr/bin" ;
our $prefix_share = "$prefix/usr/share/sched" ;

# $1 => job_id
our $re_jobid  = '([\w\d\.-]+)' ;

# $1 => sid
# $2 => serial
# $3 => host
# $4 => job
our $re_jobsid = '(([\w\d\.-]+):([\w\d\.-]+):([\w\d\.-]+))' ;

# $1 => cmd_id
our $re_cmdid = $re_jobid ;

# $1 => cmd_sid
# $2 => job_sid
# $3 => serial
# $4 => host
# $5 => job
# $6 => cmd_id

our $re_cmdsid = "($re_jobsid:$re_cmdid)" ;

# $1 => host
our $re_host = '([\w\d\.-]+)' ;

# $1 => ip
our $re_ip = '(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})' ;

=head1 FUNCTION &Sched::cfg

  This function acces to Config::IniFiles, it use
  [$type] (master, xfer, slave, job)

=head2 USAGE 

  &Sched::init($type, $config_file) ;
  &Sched::cfg($item) ;

=cut

sub cfg($)
{
    my $item = shift ;
    if ($type) {
	return $Sched::cfg->val($type, $item) ;
    } else {
	return undef ;
    }
}

=head1 FUNCTION &Sched::init_test

  This function it use by test fonction (src/t/)

=head2 USAGE

  &Sched::init_test() ;

=cut

sub init_test
{
    $log = new Log::LogLite('-', 30) ;
    $hostname = `hostname` ;
    chomp($hostname) ;
    set_jobid('test') ;
    set_serial() ;
    set_sid() ;
}

=head1 FUNCTION &Sched::init

  This function setup basic variables (log, cfg, hostname..)

=head2 USAGE

  &Sched::init($type, $cfg_file) ;

   o $type = 'master' | 'slave' | 'xfer' | 'job'
   o $cfg_file = /path/to/config/file

=cut

sub init($$)
{
    my ($t, $inifile) = @_ ;
    my $ret = 1 ;

    $type = $t ;

    $cfg = new Config::IniFiles( -file => $inifile ) or
	die "E : impossible d'utiliser $inifile $!" ;
    
    if (($type eq 'master') or
	($type eq 'slave')  or
	($type eq 'job')    or
	($type eq 'cgi')       ) 
    {
	$log = new Log::LogLite( $cfg->val('main', 'logfile') || '-',
				 $cfg->val('main', 'debug')) ;

    } elsif ($type eq 'utils') {
	$log = new Log::LogLite( '-', $cfg->val('main', 'debug')) ;	
    } else {
	$log = new Log::LogLite( $cfg->val('main', 'logfile') || '-',
				 $cfg->val('main', 'debug')) ;
    }

    if ($cfg->val('main', 'debug') <= 10) {
       $log->template("[<date>] <message>\n") ;
    } 

    $log->write("I : Demarrage en mode $t", 5) ;

    if ($type ne 'master') {
        $hostname = $cfg->val($type, 'hostname') || `hostname` ;
        chomp($hostname) ;
    } else {
	$hostname = '' ;
    }

    if ($type eq 'job' or $type eq 'slave') {
    	# le moins de dependance possible
    	eval {
	   require Sched::Net ;
	   $ret = Sched::Net::valid_conf() ;
	}
    }

    return $ret ;
}


=head1 FUNCTION &Sched::set_jobid

  This function it use to set jobid

=head2 USAGE

  &Sched::set_jobid(jobid) ;

=cut

sub set_jobid($)
{
    $jobid = shift ;
}



=head1 FUNCTION &Sched::set_job_file

  This function it use to set job_file (md5 calculation for example)

=head2 USAGE

  &Sched::set_job_file(file) ;

=cut

sub set_job_file($)
{
    $job_file = shift ;
}




=head1 FUNCTION &Sched::set_serial

  This function it use to set serial
  serial is a uniq identifier for a job session

  if $sid is not set, it'll we set to  $serial::$hostname

=head2 USAGE

  &Sched::set_serial($serial) ;

   o $serial = undef | serial

=cut

sub set_serial
{
    $serial = shift || get_serial() ;
    set_sid("$serial:$hostname") if (!$sid) ;
}



=head1 FUNCTION &Sched::get_serial

  Le serial est utilise pour identifier une session job 

=head2 USAGE


=cut

sub get_serial
{
    my $s = POSIX::strftime("%Y%m%d%H%M%S", localtime(time())) . "-$$" ;
    return $s ;
}


=head1 FUNCTION &Sched::set_sid

  sid is a job uniq indentifier (if job launch other job for example)
  if sid is empty $serial:$hostname:$jobid

=head2 USAGE

  &Sched::set_sid($sid) ;
  
    o $sid = undef | serial

=cut

sub set_sid
{
    $sid = shift || "$serial:$hostname:$jobid" ;
}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

