package SchedUI::Template ;
use strict ;

our $version = '$Id: Template.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Gtk2::GladeXML ;
use SchedUI::TemplateEdit ;
use Sched::NS ;
use Sched::Callback ;

sub new
{
    my ($class, $xml) = @_ ;

    my $self = { 
	xml => $xml, 
	uid => Sched::NS::get_uid(),
	} ;
    
    bless ($self, $class) ;

    my $g = new Gtk2::GladeXML($SchedUI::glade_file, 'select_template') ;
    $self->{glade} = $g ;

    $g->signal_autoconnect_from_package($self) ;

    my $simplelist = Gtk2::SimpleList->new_from_treeview (
                           $g->get_widget('treeview'),
                           'Template id'    => 'text',
                           'Comment'        => 'text',
                        );
    
    $self->{slist} = $simplelist ; 

    Sched::Callback::add_cb("CHANGE $self->{uid}", 
			    \&_update,[$self]
			    ) ;

    $self->_update() ;
    
    return $self ;
}

sub get_template
{
    my ($self, $id) = @_ ;
    for my $t (@{ $self->{xml}->getAllChildren('template') }) {
	if ($t->attribute('id') eq $id) {
	    return $t ;
	}
    }

    return undef ;
}

sub get_all_template
{
    my ($self) = @_ ;
    my @ret ;
    for my $t (@{ $self->{xml}->getAllChildren('template') }) {
	push @ret, $t->attribute('id') ;
    }

    @ret = sort @ret ;
    return @ret ;
}

sub show
{
    my ($self, $entry_template) = @_ ;

    $self->{entry_template} = $entry_template ;
    $self->_update() ;
    $self->{glade}->get_widget('select_template')->show() ;
}

sub template_edit
{
    my ($self, $template_id) = @_;

    return unless ($template_id) ;

    for my $t (@{ $self->{xml}->getAllChildren('template') }) {
	if ($t->attribute('id') eq $template_id) {
	    my $tedit = new SchedUI::TemplateEdit($self->{uid}, $t) ;
	    return ;
	}
    }
}

sub on_properties_clicked
{

    my $self = shift ;

    my ($sel, $id) = $self->get_selection() ;

    return unless (defined $sel) ;

    $self->template_edit($id) ;
}

sub _update
{
    my $self = shift ;
    @{$self->{slist}->{data}} = () ;

    for my $t (@{$self->{xml}->getAllChildren('template')}) {
	push @{$self->{slist}->{data}},
	    [$t->attribute('id'), 
             MIME::Base64::decode_base64($t->attribute('comment') || '')] ;
    }
}

sub on_cmdline_row_activated
{
    my $self = shift ;
    $self->on_properties_clicked() ;
}

sub on_add_clicked
{
    my $self = shift ;

    my $root = $self->{xml} ;
    my $t = $root->createChild('template') ;
    $t->attribute('id', Sched::NS::get_uid()) ;
    

    my $tedit = new SchedUI::TemplateEdit($self->{uid}, 
					  $t) ;
}


sub get_selection
{
    my ($self) = @_ ;
    # recuperation de l'indice
    my @indices = $self->{slist}->get_selected_indices() ;
    # on ne prend que le premier
    my $sel = pop @indices ;

    return undef if (!defined $sel) ;

    # recuperation de l'id
    return ($sel, $self->{slist}->{data}[$sel][0]) ;
}

sub on_remove_clicked
{
    my $self = shift ;

    my ($sel, $id) = $self->get_selection() ;

    return if (! defined $sel) ;

    # suppression du noeud XML::Smart
    for my $t (@{$self->{xml}->getAllChildren('template')}) {
	if ($t->attribute('id') eq $id) {
	    $t->remove() ;
	    splice @{ $self->{slist}->{data} }, $sel, 1;
	    return ;
	}
    }
}

sub on_close_clicked
{
    my ($self) = @_ ;

    if ($self->{entry_template}) {
	delete $self->{entry_template} ;
    }

    my $w = $self->{glade}->get_widget('select_template') ;
    $w->hide() ;
}

sub get
{
    my $tedit = Sched::NS::aa('=template=') ;
    
    if (!$tedit) {
	my $root = Sched::NS::aa('=xml-root=') ;

	$tedit = new SchedUI::Template($root);
	Sched::NS::register_id('=template=', $tedit) ;
    }
    return $tedit ;
}

sub on_ok_clicked
{
    my ($self) = @_ ;
    if ($self->{entry_template}) {
	my (undef, $id) = $self->get_selection() ;

	$self->{entry_template}->set_text($id) 
	    if ($id) ;

	delete $self->{entry_template} ;
    }

    $self->on_close_clicked() ;
}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

