package SchedUI::Msg ;

our $version = '$Id: Msg.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use strict ;

use SchedUI ;
use Sched::NS ;
use Gtk2::GladeXML ;

sub display_warning
{
    my $msg = shift ;
    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, "dlg_warning") ;

    $g->get_widget('error')->set_text($msg) ;
    $g->get_widget('closebutton')->signal_connect('clicked', 
						sub { my ($bp, $window) = @_ ;
						      $window->destroy(); 
						}, 
					        $g->get_widget('dlg_warning'));
}

sub display_status
{
    my $msg = shift || '' ;

    my $w = Sched::NS::aa('=status-widget=') ;
    if ($w) {
	$w->set_status($msg) ;
    } else {
	print "E : impossible de trouver =status-widget=\n" ;
    }
}


1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

