package SchedUI::LineManager ;
use strict ;

our $version = '$Id: LineManager.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Gnome2::Canvas;


=head1 FUNCTION SchedUI::LineManager->new

Initialize a LineManager environnment.

=head2 USAGE

$manager = SchedUI::LineManager->new($canvas->root) ;

=head2 ATTRIBUTE

    connect (h) : id1 = (id2, id3...)
    line  (h) : "id1|id2" = Gnome::Canvas::Line
    group (r) : Gnome::Canvas::Group
    

=head2 TODO

pour ne pas effacer les liens de parente
on peut utiliser 2 gestionnaires de lien...
un pour le XML (d'une certaine couleur d'ailleur)
et l'autre pour les conditions !

vivement demain

=cut

sub new
{
    my ($class, $group) = @_ ;
    
    my $self = bless {} ;

    $self->{fill_color} = 'black' ;
    $self->{offset} = 0 ;
    $self->{connect} = () ;
    $self->{line} = () ;
    my $gr = Gnome2::Canvas::Item->new($group,
				       'Gnome2::Canvas::Group',
				       x => 0.0, y => 0.0) ;

    $gr->lower_to_bottom() ;
    $self->{group} = $gr ;

    return $self ;
}

sub set_color
{
    my ($self, $color) = @_ ;
    $self->{fill_color} = $color ;
}

sub is_connected
{
    my ($self, $id1, $id2) = @_ ;

    return 1 if ($id1 eq $id2) ;

    if ($self->{line}{"$id1|$id2"} || $self->{line}{"$id2|$id1"}) {
	return 1 ;
    } else {
	return 0 ;
    }
}


# xml obj
sub add_line_between_obj
{
    my ($self, $obj1, $obj2) = @_ ;

    return if (!$obj2 or !$obj1) ;

    my ($id1, $id2) = ($obj1->uid, $obj2->uid) ;

    if ($self->is_connected($id1, $id2)) {
	print "E : already connected $id1 -> $id2\n" ;
	return 0 ;
    }

    my ($x1, $y1, $x2, $y2) = calc_xy($obj1, $obj2, $self->{offset}) ;

    my $l = Gnome2::Canvas::Item->new ($self->{group},
				       'Gnome2::Canvas::Line',
				       points => [$x1, $y1, $x2, $y2],
				       fill_color => $self->{fill_color},
				       width_units => 4.0);

    $self->add_connect($id1, $id2) ;
    $self->add_connect($id2, $id1) ;

    $self->{line}{"$id1|$id2"} = $l ;
    $l->set('last-arrowhead', 1) ;
    $l->set('arrow-shape-a', 10) ;
    $l->set('arrow-shape-b', 11) ;
    $l->set('arrow-shape-c', 5) ;


    return 1 ;
}

sub remove_line_between_obj
{
    my ($self, $obj1, $obj2) = @_ ;

    my ($id1, $id2) = ($obj1->uid, $obj2->uid) ;
    
    $self->remove_line_between_uid($id1, $id2) ;
}
sub remove_line_between_uid
{
    my ($self, $id1, $id2) = @_ ;

    if (!$self->is_connected($id1, $id2)) {
	print "E : not connected\n" ;
	return 0 ;
    }

    $self->remove_connect($id1, $id2) ;
    $self->remove_connect($id2, $id1) ;
    
    my $l = $self->{line}{"$id1|$id2"}  ;
    if ($l) {
	$l->destroy() ;
	delete $self->{line}{"$id1|$id2"}  ;
    } else {
	$l = $self->{line}{"$id2|$id1"}  ;
	if ($l) {
	    $l->destroy() ;
	    delete $self->{line}{"$id2|$id1"}  ;
	} else {
	    print "E : error during disconnect\n" ;
	}
    }
}

sub remove_connect
{
    my ($self, $id1, $id2) = @_ ;

    $self->{connect}{$id1} = [grep(!/^$id2$/, @{$self->{connect}{$id1}})]  ;

    return 1 ;
}

sub add_connect
{
    my ($self, $id1, $id2) = @_ ;

    push @{$self->{connect}{$id1}}, $id2 ;

    return 1 ;
}

sub get_connection
{
    my ($self, $id1) = @_ ;

    if (exists $self->{connect}{$id1}) {
	return @{$self->{connect}{$id1}} ;
    } else {
	return ;
    }
}

sub set_offset
{
    my $self = shift ;
    $self->{offset} = shift ;
}

sub move_obj
{
    my ($self, $obj1) = @_ ;

    my $id1 = $obj1->uid ;

    my @conn = $self->get_connection($id1) ;
    for my $c (@conn) {
	my $obj2 = Sched::NS::aa($c) ;

	next if (!$obj2) ;

	my ($x1, $y1, $x2, $y2) = calc_xy($obj1, $obj2, $self->{offset}) ;

	my $l = $self->{line}{"$id1|$c"} ;
	if ($l) {	    
	    $l->set(points => [$x1, $y1, $x2, $y2]) ;
	} else {
	    $l = $self->{line}{"$c|$id1"} ;
	    if ($l) {
		$l->set(points => [$x2, $y2, $x1, $y1]) ;
	    }
	}
    }
}


sub calc_xy
{
    # pos permet de deplacer legerement le pt d'ancrage
    my ($parent, $child, $pos) = @_ ;
    
    $pos = $pos || 0 ;

    my ($w, $h) = ($SchedUI::Item::width, $SchedUI::Item::heigh) ;

    # $x et $y en haut a gauche
    my ($xp, $yp) = ($parent->x, $parent->y) ;

    my ($xc, $yc) = ($child->x, $child->y) ;

    # resultat
    my ($xlc, $ylc, $xlp, $ylp) ;

    if (($xc + $w) <= $xp) {
	$xlc = $xc + $w ;
	$ylc = $yc + $h/2 + $pos ;

	$xlp = $xp ;
	$ylp = $yp + $h/2 + $pos ;
    } elsif ($xc >= ($xp + $w)) {
	$xlc = $xc ;
	$ylc = $yc + $h/2 + $pos ;

	$xlp = $xp + $w ;
	$ylp = $yp + $h/2 + $pos ;
    } elsif ($yc >= ($yp + $h)) {
	$xlc = $xc + $w/2 + $pos ;
	$ylc = $yc ;

	$xlp = $xp + $w/2 + $pos ;
	$ylp = $yp + $h ;
    } elsif ($yc <= $yp) {
	$xlc = $xc + $w/2 + $pos ;
	$ylc = $yc + $h ;

	$xlp = $xp + $w/2 + $pos ;
	$ylp = $yp ;
    } else {
	$xlc = $xc ;
	$xlp = $xp ;

	$ylc = $yc ;
	$ylp = $yp ;
    }


    return ($xlp, $ylp, $xlc, $ylc) ;
}


sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

