package SchedUI::JobPane;
use strict ;

our $version = '$Id: JobPane.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Sched::NS ;
use SchedUI::Msg ;
use SchedUI::Item ;
use Gtk2::GladeXML;
use Gnome2::Canvas ;
use Glib ;

my $canvas_width = 600 ;
my $canvas_heigh = 450 ;

sub on_open1_activate
{
    my ($self) = @_ ;
    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, "dlg_open") ;

    my $dlg = $g->get_widget('dlg_open') ;

    if ($dlg->run() eq 'ok') {
	new_builder($dlg->get_filename()) ;
    } 
    
    $dlg->destroy();
}

sub on_zoom_changed 
{
    my ($self, $spin) = @_;
    my $canvas = $self->{canvas} ;
    my $adj = $spin->get_adjustment() ;
    $canvas->set_pixels_per_unit ($adj->value);
}

sub get_min_max_pos
{
    my ($xml, $xmin, $ymin, $xmax, $ymax) = @_ ;
    
    if (!$xml) {
	return ($xmin, $ymin, $xmax, $ymax) ;
    }

    my $children = $xml->getAllChildren();

    foreach my $child (@{$children})
    {
	if (defined $child->attribute('x') 
	    and
	    defined $child->attribute('y')) 
	{
	    my ($x, $y) = ($child->attribute('x'), $child->attribute('y')) ;
	    
	    if ($x < $xmin) {
		$xmin = $x ;
	    } elsif ($x > $xmax) {
		$xmax = $x ;
	    }

	    if ($y < $ymin) {
		$ymin = $y ;
	    } elsif ($y > $ymax) {
		$ymax = $y ;
	    }
	    
	    ($xmin, $ymin, $xmax, $ymax) 
		= get_min_max_pos($child, $xmin, $ymin, $xmax, $ymax) ;

	}
    }

    return ($xmin, $ymin, $xmax, $ymax) ;
}

sub on_zoom_show_all
{
    my ($self) = @_;

    my $xml = Sched::NS::aa('=xml-root=') ;
    # calcul de la taille maxi des objets
    my ($xmin, $ymin, $xmax, $ymax) = get_min_max_pos($xml, 0,0,0,0 ) ;

    # recuperation de la taille du canvas
    my $sw = $self->{glade}->get_widget('scrolledwindow_canvas') ;
    my $ha = $sw->get_hadjustment() ;
    my $va = $sw->get_vadjustment() ;

    my ($w, $h) = ($ha->page_size() || $canvas_width,
		   $va->page_size() || $canvas_heigh) ;

    # calcul du zoom pour tout afficher sur x puis sur y
    my $zoom_y =  $h / ($ymax + $SchedUI::Item::heigh - $ymin + 15) ;
    my $zoom_x =  $w / ($xmax + $SchedUI::Item::width - $xmin + 15) ;

    # on prend le plus gros (pour etre sur de tout afficher)
    my $zoom = ($zoom_x < $zoom_y) ? $zoom_x : $zoom_y ;
    
    # mise en place du zoom
    $self->{canvas}->set_pixels_per_unit($zoom) ;

    # mise a jour du bp spin de la toolbox
    my $spin = $self->{glade}->get_widget("spin_zoom") ;
    my $adj = $spin->get_adjustment() ;
    $adj->set_value($zoom) ;
}

sub on_quit_clicked
{
    my $self = shift ;
    exit (0) ;
    #my $w = $self->{glade}->get_widget("window_job") ;
    #$w->destroy() ;
    #delete $self->{glade} ;
    Gtk2::main_quit() ;
}


sub new_builder
{
    my ($file) = @_ ;

    if (!fork()) {
	if (($file) and (-f $file)) {
	    exec ($0, "-j", $file) ;
	} else {
	    exec $0 ;
	}
	exit 1 ;
    }
 
}

sub on_new_clicked
{
    new_builder() ;
}

sub on_save_clicked
{
    my ($self) = @_ ;
    my $file = Sched::NS::aa('=file-job=') ;

    if (!open (FP, ">$file")) {
	SchedUI::Msg::display_warning("Can't save to $file ($!)");
	SchedUI::Msg::display_status("I : Can't save to '$file'") ;
	return ;
    }
    my $xml = Sched::NS::aa('=xml-root=') ;
    if (print FP $xml->toString()) {
	SchedUI::Msg::display_status("I : Save to '$file' ran OK") ;
    }
    close(FP) ;
}

sub on_saveas_clicked
{
    my ($self) = @_ ;
    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, "dlg_saveas") ;

    my $dlg = $g->get_widget('dlg_saveas') ;

    if ($dlg->run() eq 'ok') {
	Sched::NS::register_id('=file-job=', $dlg->get_filename()) ;
	$self->on_save_clicked() ;
    } 
    
    $dlg->destroy();
}

sub on_about1_activate
{
    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, "about") ;
}

sub on_add_template_activate
{
    my ($self) = @_ ;
}

sub canvas
{
    my ($self) = @_ ;
    return $self->{canvas} ;
}

sub new
{
    my ($class, $xml) = @_ ;
    my $self = bless {} ;

    my $glade = Gtk2::GladeXML->new($SchedUI::glade_file, "window_job") ;
    $self->{glade} = $glade ;

    Sched::NS::register_id('=status-widget=', $glade->get_widget('appbar')) ;

    my $s = $glade->get_widget('scrolledwindow_canvas') ;
    my $c = Gnome2::Canvas->new_aa() ;
    $self->{canvas} = $c ;

    $c->set_center_scroll_region (Glib::FALSE);

    $c->set_size_request ($canvas_width, $canvas_heigh);
    $c->set_scroll_region (0, 0, $canvas_width, $canvas_heigh);
    $c->set_flags ('can-focus');
    $c->grab_focus;
    $s->set_hadjustment($c->get_hadjustment) ;
    $s->set_vadjustment($c->get_vadjustment) ; 
    
    $s->add($c) ;
    $c->show() ;

    $glade->signal_autoconnect_from_package($self) ;
    $glade->get_widget('window_job')->show() ;
    return $self ;
}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

