package SchedUI::JobItem ;
use strict ;
use integer ;

our $version = '$Id: JobItem.pm,v 1.2 2005/04/09 09:39:32 mcgregor Exp $' ;

use Gtk2::GladeXML;
use Gnome2::Canvas ;
use Glib ;
use XML::Mini::Document ;

use Sched::NS ;
use SchedUI::Item ;
use SchedUI::TaskItem ;
use SchedUI::CommentItem ;
use SchedUI::JobEdit ;
use SchedUI::Template ;
use SchedUI::Variable ;
use SchedUI::Cmd ;
use SchedUI::LineManager ;

my $pix_job = "$SchedUI::pix_path/package.png" ;

our @ISA = 'SchedUI::Item' ;

=head1 PACKAGE SchedUI::JobItem

Permet de gerer les objets Job

=head2 ATTRIBUTE

    widget_popup (r)  : ref to context menu
    xml (r)         : ref to XML::Item::Element description

    _old_id (s)     : permet de savoir si l'id est modifie dans un update

    job_uid (s)     : uid du job en cours d'edition (NS)

=cut

=head1 FUNCTION SchedUI::JobItem->new

=head2 USAGE

    xml  => XML::Mini::Element
    data => <job .. />
    
=cut


sub new
{
    my ($class, %arg) = @_ ;
    
    my $self = bless ({}, $class) ;

    if (exists $arg{xml}) {
	$self->{xml} = $arg{xml} ;
    } elsif (exists $arg{data}) {
	my $xml = new XML::Mini::Document() ;
	$xml->parse($arg{data}) ;
	$xml = $xml->getRoot()->getElement('job') ;

	if (!$xml) {
	    print "E : impossible d'initialiser $class\n" ;
	    return undef; 
	}
	
	$self->{xml} = $xml ;

    } else {
	print "E : impossible d'initialiser $class\n" ;
	return undef; 
    }
    
    $self->uid(Sched::NS::get_uid()) ;
    $self->{job_uid} = $self->uid ;

    Sched::NS::set_jobid($self->uid) ;
    Sched::NS::register_id('=xml-root=', $self->{xml}) ;
    Sched::NS::register_id($self->uid, $self) ;
    Sched::NS::register_id($self->id, $self->uid) ;

    Sched::Callback::add_cb("CHANGE " . $self->uid, \&_update, [$self]) ;

    $self->{_old_id} = $self->id ;

    return $self ;
}

sub on_manage_variable_activate
{
    my ($self) = @_ ;
    Sched::NS::set_jobid($self->uid) ;

    my $vedit = SchedUI::Variable::get() ;
    $vedit->show() ;
}

sub on_manage_template_activate
{
    my ($self) = @_ ;
    Sched::NS::set_jobid($self->uid) ;

    my $tedit = SchedUI::Template::get() ;
    $tedit->show() ;
}

sub on_manage_command_activate
{
    my ($self) = @_ ;
    Sched::NS::set_jobid($self->uid) ;
    my $cedit = SchedUI::Cmd::get() ; 

    $cedit->show() ;
}

# cb popup
sub on_add_task_activate
{
    my ($self) = @_ ;

    SchedUI::TaskItem::on_add_sub_task_activate($self) ; 
}
sub on_add_comment_activate
{
    my ($self) = @_ ;

    Sched::NS::set_jobid($self->{job_uid}) ;    
    my $xml = $self->{xml} ;

    my $c = $xml->createChild('comment') ;
    $c->attribute('id', Sched::NS::get_uid()) ;
    $c->attribute('text', 'Y29tbWVudA==') ;

    my $ci = new SchedUI::CommentItem(xml => $c) ;

    my $group =  Sched::NS::aa('=group=') ;
    $ci->display($group) ;
}

# very ugly...
sub on_paste_task_activate
{
    my ($self, $w) = @_ ;
    SchedUI::TaskItem::on_paste_task_activate($self, $w) ; 
}


# callback sur un event Callback de changement
sub _update
{
    my $self = shift ;

    if ($self->id ne $self->{_old_id}) {

	&Sched::NS::set_jobid($self->uid) ;
	&Sched::NS::rename_id($self->{_old_id}, $self->id) ;

	$self->{_old_id} = $self->id ;
	$self->{label}->set('text', $self->id) ;
    }   
}

# cb popup properties
sub on_properties_job_activate
{
    my ($self) = @_ ;
    my $p = new SchedUI::JobEdit($self->uid, $self->{xml}) ;
}

# cb de la souris
sub _job_event
{
    my ($item, $event, $self) = @_;

    if ($event->type eq 'button-press') {
	if ($event->button == 3) {
	    $self->{widget_popup}->popup(undef,
					 undef, 
					 undef,
					 undef,
					 $event->button, $event->time) ;
	} elsif ($event->button == 2) {
	    $self->on_properties_job_activate() ;
	} 
    }
}

# ajout sur un Gnome2::Canvas::Item
sub display
{
    my ($self, $group) = @_ ;

    $self->x(135) ;
    $self->y(70) ;

    my $gr = Gnome2::Canvas::Item->new($group,
				       'Gnome2::Canvas::Group',
				       x => $self->x, y => $self->y) ;



    my $r = Gnome2::Canvas::Item->new ($gr,
				       'Gnome2::Canvas::Rect',
				       x1 => 0,
				       y1 => 0,
				       x2 => $SchedUI::Item::width,
				       y2 => $SchedUI::Item::heigh,
				       fill_color_rgba => 0x3cb37180,
				       outline_color => 'black',
				       width_units => 4.0);

    Gnome2::Canvas::Item->new($gr, 'Gnome2::Canvas::Pixbuf',
			 pixbuf => Gtk2::Gdk::Pixbuf->new_from_file($pix_job),
			 x => 20*$SchedUI::Item::width/100,
			 y => 10*$SchedUI::Item::heigh/100,
			 ) ;

    $self->{label} = Gnome2::Canvas::Item->new ($gr, 'Gnome2::Canvas::Text',
					text => $self->id,
					x => 0,
					y => - $SchedUI::Item::heigh/2.5,
					font => 'Sans 12',
					anchor => 'n', #GTK_ANCHOR_N,
					fill_color => 'black');

    $gr->signal_connect (event => \&_job_event, $self);

    # chargement du menu clique droit
    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, 'menu_job') ;
    $g->signal_autoconnect_from_package($self) ;

    Sched::NS::set_jobid($self->uid) ;

    # creation d'un gestionnaire de connexion
    my $l_err = new SchedUI::LineManager($group) ;
    Sched::NS::register_id('=link-cond-err=', $l_err) ;
    $l_err->set_color('red') ;

    my $l_ok = new SchedUI::LineManager($group) ;
    Sched::NS::register_id('=link-cond-ok=', $l_ok) ;
    $l_ok->set_color('green') ;

    my $l_result = new SchedUI::LineManager($group) ;
    Sched::NS::register_id('=link-cond-result=', $l_result) ;
    $l_result->set_color('brown') ;

    my $l_finish = new SchedUI::LineManager($group) ;
    Sched::NS::register_id('=link-cond-finish=', $l_result) ;
    $l_result->set_color('LightSkyBlue1') ;

    my $l_chld = new SchedUI::LineManager($group) ;
    Sched::NS::register_id('=link-xml=', $l_chld) ;
    $l_chld->set_offset(10) ;

    Sched::NS::register_id('=group=', $group) ;

    $self->{widget_popup} = $g->get_widget('menu_job') ;
}


sub test
{

}

1;

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

