package SchedUI::JobEdit ;
use strict ;

=head1 PACKAGE SchedUI::JobEdit

Ce module permet de configurer un Job

=cut


use SchedUI::ItemEdit ;
our @ISA = 'SchedUI::ItemEdit' ;

our $version = '$Id: JobEdit.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

sub new
{
    my ($class, $uid, $xml) = @_ ;

    my $self = $class->SUPER::new($uid, $xml) ;
    bless ($self, $class) ;

    $self->{entry} = ['id', 'host'] ;
    $self->{text} = ['cond', 'comment', 'env'] ;
    $self->{spin} = ['maxtime'] ;

    $self->{encode} = ['comment', 'cond', 'env'] ;

    $self->{verify}->{host} =  '^[${}\w\d\.-]*(,[${}\w\d\.-]+)*$' ;

    $self->init() ;

    return $self ;
}
sub on_cond_edit_clicked
{
    my ($self) = @_ ;
    my $c = new SchedUI::CondEdit($self->{xml}, 
				  $self->{glade}->get_widget('text_cond')) ;
}
sub test
{

}

1;

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

