package SchedUI::CondEdit ;
use strict ;

our $version = '$Id: CondEdit.pm,v 1.2 2005/04/09 09:39:32 mcgregor Exp $' ;

=head1 PACKAGE SchedUI::CondEdit

    Ce package gere l'edition des conditions

=head2 ATTRIBUTE

    glade (r) : ref to Gtk2::GladeXML description
    slist (r) : ref to Gtk2::SimpleList widget

    text_cond (r) : ref to Gtk2::TextView (target)

=head2 TODO



=cut

use SchedUI ;
use Gtk2::GladeXML ;
use Gtk2::SimpleList ;
use Sched::Job ;

# new CondEdit (xml, GtkEntry)
sub new
{
    my ($class, $target, $text_cond) = @_ ;
    my $self = bless {} ;

    $self->{text_cond} = $text_cond ;

    my $g = new Gtk2::GladeXML($SchedUI::glade_file, "dlg_cond") ;
    $g->signal_autoconnect_from_package($self) ;
    $self->{glade} = $g ;

    my $simplelist = Gtk2::SimpleList->new_from_treeview (
                           $g->get_widget('treeview_depend'),
                           'Task id'    => 'text',
                           'if ok'      => 'bool',
                           'if error'   => 'bool',
                           'if finish'  => 'bool',
                        );
    #$g->get_widget('treeview_depend')->set('enable-search', 1) ;
    #$g->get_widget('treeview_depend')->set('search-column', 1) ;

    my $root = Sched::NS::aa('=xml-root=') ;

    my %all = map { $_ => 0 } Sched::Job::get_all_id($root) ;

    my $cond = $target->attribute('cond') || '';
    $cond = MIME::Base64::decode_base64($cond) ;

    if ($cond eq '1') {
	my $w = $self->{glade}->get_widget('always_ok') ;
	$w->set_active(1) ;
    } elsif ($cond) {
	my $w = $self->{glade}->get_widget('expert_ok') ;
	$w->set_active(1) ;

	my @lst ;
	@lst =  Sched::Cond::depend_on_ok($cond) ;
	map { $all{$_} = 1 } @lst ;

	@lst =  Sched::Cond::depend_on_err($cond) ;
	map { $all{$_} = 2 } @lst ;

	@lst =  Sched::Cond::depend_on_finish($cond) ;
	map { $all{$_} = 3 } @lst ;
    }

    delete $all{$target->attribute('id')} ;

    push @{$simplelist->{data}}, map { [$_, $all{$_} == 1, $all{$_} == 2, $all{$_} == 3]} sort keys %all ;

    $self->{slist} = $simplelist ;
    # cond vide => default ok
    
    return $self ;
}

sub on_ok_clicked
{
    my ($self) = @_ ;

    my $cb ;

    my $slist = $self->{slist} ;

    my $b = new Gtk2::TextBuffer() ;

    $cb = $self->{glade}->get_widget('parent_ok') ;
    if ($cb->get_active()) {
	$b->set_text("") ;
    } else {
	$cb = $self->{glade}->get_widget('always_ok') ;
	if ($cb->get_active()) {
	    $b->set_text("1") ;
	} else {
	    my @ret ;

	    # ($result{test1} == 0) && ($result{test2})

	    for my $l (@{$slist->{data}}) {
		my ($id, $ok, $err, $finish) = @{$l} ;
		push @ret, "ok('$id')" if ($ok) ;
		push @ret, "err('$id')" if ($err) ;
		push @ret, "finish('$id')" if ($finish) ;
	    }
	    $b->set_text(join("\n \&\& \n", @ret)) ;
	}
    }
    # set cond text box
    my $w = $self->{text_cond} ;
    $w->set_buffer($b) ;

    $self->on_cancel_clicked() ;
}

sub on_cancel_clicked
{
    my $self = shift ;

    my $w = $self->{glade}->get_widget('dlg_cond') ;
    $w->destroy() ;

    delete $self->{glade} ;
    delete $self->{text_cond} ;
    delete $self->{slist} ;

}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

