package SchedUI::Variable ;
use strict ;

our $version = '$Id: Variable.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Gtk2::GladeXML ;
use Sched::NS ;
use Sched::Callback ;

sub new
{
    my ($class) = @_ ;

    my $self = { 
	uid => Sched::NS::get_uid(),
	} ;
    
    bless ($self, $class) ;

    my $g = new Gtk2::GladeXML($SchedUI::glade_file, 'dlg_var') ;
    $self->{glade} = $g ;

    $g->signal_autoconnect_from_package($self) ;

    my $simplelist = Gtk2::SimpleList->new_from_treeview (
                           $g->get_widget('treeview'),
                           'Variable name'    => 'text',
                           'Comment'          => 'text',
                        );
    
    $self->{slist} = $simplelist ; 

    Sched::Callback::add_cb("CHANGE $self->{uid}", 
			    \&_update,[$self]
			    ) ;

    $self->_update() ;
    
    return $self ;
}

sub get_widget
{
    my ($self, $what) = @_ ;

    return $self->{glade}->get_widget($what) ;
}

sub show
{
    my ($self) = @_ ;

    $self->_update() ;

    $self->get_widget('entry_name')->set_text('') ;
    $self->get_widget('entry_value')->set_text('') ;

    my $b = new Gtk2::TextBuffer() ;
    $b->set_text('') ;
    $self->get_widget('text_comment')->set_buffer($b) ;

    $self->get_widget('dlg_var')->show() ;
}

sub on_update_clicked
{

}

sub _update
{
    my $self = shift ;
    @{$self->{slist}->{data}} = () ;

    my $xml = Sched::NS::aa('=xml-root=') ;

    for my $v (@{$xml->getAllChildren('var')}) {
	push @{$self->{slist}->{data}},
	             [$v->attribute('name'), 
		      MIME::Base64::decode_base64($v->attribute('comment'))] ;
    }
}

sub on_cmdline_row_activated
{
    my ($self) = @_ ;
    # recuperation de l'indice
    my @indices = $self->{slist}->get_selected_indices() ;
    # on ne prend que le premier
    my $sel = pop @indices ;

    return undef if (!defined $sel) ;

    my $t ;
    my $w ;
    
    $w = $self->get_widget('entry_name') ;
    $t = $self->{slist}->{data}[$sel][0] ;
    $w->set_text($t) ;

    my $root = Sched::NS::aa('=xml-root=') ;
    for my $v (@{$root->getAllChildren('var')}) {
	if ($v->attribute('name') eq $t) {
	    $t = MIME::Base64::decode_base64($v->attribute('value')) ;
	    last ;
	}
    }

    $w = $self->get_widget('entry_value') ;
    $w->set_text($t) ;

    $w = $self->get_widget('text_comment') ;
    $t = $self->{slist}->{data}[$sel][1] ;

    my $b = new Gtk2::TextBuffer() ;
    $b->set_text($t) ;
    $w->set_buffer($b) ;
}

sub on_add_clicked
{
    my $self = shift ;

    my $root = Sched::NS::aa('=xml-root=') ;

    my $w ;
    my ($n,$t,$c) ;

    $w = $self->get_widget('entry_name') ;
    $n = $w->get_text() ;

    return unless ($n =~ /^[\w\d\.-]+$/) ;

    my $v = $root->createChild('var') ;
    $v->attribute('name', $n) ;

    $w = $self->get_widget('entry_value') ;
    $t = $w->get_text() || '';

    $v->attribute('value', MIME::Base64::encode_base64($t, '')) ;

    $w = $self->get_widget("text_comment") ;
    my $b = $w->get_buffer() ;
    my $s = $b->get_iter_at_offset(0) ;
    my $e = $b->get_iter_at_offset(-1) ;
    
    $c = $b->get_text($s, $e, 1) || '';

    $v->attribute('comment', MIME::Base64::encode_base64($c, '')) ;

    push @{$self->{slist}->{data}}, [$n, $c] ;

}

sub get
{
    my $vedit = Sched::NS::aa('=variable=') ;
    
    if (!$vedit) {
	$vedit = new SchedUI::Variable();
	Sched::NS::register_id('=variable=', $vedit) ;
    }
    return $vedit ;
}


sub get_selection
{
    my ($self) = @_ ;
    # recuperation de l'indice
    my @indices = $self->{slist}->get_selected_indices() ;
    # on ne prend que le premier
    my $sel = pop @indices ;

    return undef if (!defined $sel) ;

    # recuperation de l'id
    return ($sel, $self->{slist}->{data}[$sel][0]) ;
}

sub on_remove_clicked
{
    my $self = shift ;

    my ($sel, $id) = $self->get_selection() ;

    return if (! defined $sel) ;

    my $xml = Sched::NS::aa('=xml-root=') ;

    # suppression du noeud XML::Mini
    for my $v (@{$xml->getAllChildren('var')}) {
	if ($v->attribute('name') eq $id) {
	    $v->remove() ;
	    splice @{ $self->{slist}->{data} }, $sel, 1;
	    return ;
	}
    }
}

sub on_close_clicked
{
    my ($self) = @_ ;

    my $w = $self->get_widget('dlg_var') ;
    $w->hide() ;
}

sub on_ok_clicked
{
    my ($self) = @_ ;
    $self->on_close_clicked() ;
}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

