package SchedUI::TemplateEdit ;
use strict ;

=head1 PACKAGE SchedUI::TemplateEdit

    Ce package permet d'editer les proprietes d'un template

=cut

use SchedUI::ItemEdit ;
our @ISA = 'SchedUI::ItemEdit' ;

our $version = '$Id: TemplateEdit.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

sub new
{
    my ($class, $uid, $xml) = @_ ;

    my $self = $class->SUPER::new($uid, $xml) ;
    bless ($self, $class) ;

    $self->{entry} = ['id', 'host', 'cmdline', 'stdout', 'stderr', 'stdin',
		      'user', 'group'] ;
    $self->{text} = ['cond', 'comment', 'env', 'after_cmd'] ;
    $self->{spin} = ['maxtime'] ;

    $self->{encode} = ['comment', 'cond', 'cmdline', 'env', 'after_cmd'] ;

    $self->init() ;

    return $self ;
}

sub on_cmdline_select_clicked
{
    my ($self) = @_ ;
    my $tedit = SchedUI::Cmd::get() ;
    $tedit->show($self->get_widget('entry_cmdline')) ;
}

sub on_cond_edit_clicked
{
    my ($self) = @_ ;
    my $c = new SchedUI::CondEdit($self->{xml}, 
				  $self->get_widget('text_cond')) ;
}


sub test
{

}

1;

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

