package SchedUI::TaskItem ;
use strict ;
use integer ;

use Gtk2::GladeXML;
use Gtk2 ;
use Gnome2::Canvas ;
use Glib ;
our $version = '$Id: TaskItem.pm,v 1.2 2005/04/09 09:39:32 mcgregor Exp $' ;

use Sched::Cond ;

use Sched::NS ;
use SchedUI::Item ;
use SchedUI::TaskEdit ;
use SchedUI::Msg ;

my $pix_task = "$SchedUI::pix_path/terminal.png" ;

our @ISA = 'SchedUI::Item' ;

=head1 PACKAGE SchedUI::TaskItem

    Gestion de l'affichage un Task

=head2 USAGE

    new(job_uid => uid,
        xml => XML::Mini::Element || data => <?....?>)

=head2 ATTRIBUTE

    {_old_id}	: permet de mettre a jour le label quand il faut
    {_old_link}	: permet de mettre a jour les link entre objet

    {widget} : reference vers le Canvas::Group
    {label} : reference vers le Canvas::Item::Label

    &uid : acces au champs uid
    &id  : acces au champs (xml) id
        
=head2 TODO

    suppression de l'objet => retirer le callback
    avoir 1 seul widget popup menu (voir comment marche les data)

=cut

sub new
{
    my ($class, %arg) = @_ ;
    
    my $self = bless ({}, $class) ;

    return undef if (not exists $arg{job_uid}) ;

    $self->{job_uid} = $arg{job_uid} ;

    if (exists $arg{xml}) {
	$self->{xml} = $arg{xml} ;
    } elsif (exists $arg{data}) {
	my $xml = new XML::Mini::Document() ;
	$xml->parse($arg{data}) ;
	$xml = $xml->getRoot()->getElement('task') ;

	if (!$xml) {
	  SchedUI::Msg::display_status("E : impossible d'initialiser $class") ;
	  return undef; 
	}
	
	$self->{xml} = $xml ;

    } else {
	SchedUI::Msg::display_status("E : impossible d'initialiser $class") ;
	return undef; 
    }
    
    if (not defined $self->{xml}->attribute('id')) {
	$self->{xml}->attribute('id', Sched::NS::get_uid()) ;
    }

    $self->uid(Sched::NS::get_uid()) ;

    Sched::NS::set_jobid($self->{job_uid}) ;
    Sched::NS::register_id($self->id, $self->uid) ;
    Sched::NS::register_id($self->uid, $self) ;

    $self->{_old_id} = $self->id ;
    $self->{_old_link} = {}  ;

    Sched::Callback::add_cb("CHANGE $self->{uid}", \&_update, [$self]) ;

    return $self ;
}

sub attribute
{
    my $self = shift ;
    return Sched::Cmd::attribute($self, @_) ;
}

sub to_xml
{
    my ($self) = @_ ;
    return Sched::Cmd::to_xml($self) ;
}

sub on_cut_task_activate
{
    my ($self, $w) = @_ ;

    # TODO
    # il faut voir sans les conditions "locales"
    for my $type (@SchedUI::link_type) {
	my $l = Sched::NS::aa("=link-cond-$type=") ;
    
	if ($l->get_connection($self->uid)) {
	    SchedUI::Msg::display_status("E : impossible de supprimer cet element, des conditions sont utilisees avec") ;
	      return ;
	  }
    }

    $self->on_copy_task_activate($w) ;

    my $l = Sched::NS::aa('=link-xml=') ;

    my $parent = $self->{xml}->parent() ;

    for my $c ($l->get_connection($self->uid))
    {
	$l->remove_line_between_uid($self->uid, $c) ;
    }    

    my $parent_uid = Sched::NS::get_obj($parent->attribute('id')) ;

    my $childs = $self->{xml}->removeAllChildren() ;

    if ($childs) {
	for my $child (@{ $childs }) {
	    $parent->appendChild($child) ;

	    my $child_uid = Sched::NS::get_obj($child->attribute('id')) ;
	    $l->add_line_between_obj($parent_uid, $child_uid) ;
	}
    }

    Sched::Callback::del_cb("CHANGE $self->{uid}") ;

    Sched::NS::unregister_id($self->attribute('id')) ;
    Sched::NS::unregister_id($self->uid) ;
    
    $self->{widget}->destroy() ;
    $self->{label}->destroy() ;
    $self->{widget_popup}->destroy() ;

    $self->{xml}->remove() ;

    map { delete $self->{$_} } keys %{ $self } ;

    # parcourir toutes les task
    #	    -> copier sur le pere
    #	    -> delete
}

sub on_copy_task_activate
{
    my ($self, $w) = @_ ;

    my $text = $self->to_xml() ;
    my $clipboard = $w->get_clipboard(Gtk2::Gdk->SELECTION_PRIMARY) ;
    $clipboard->set_text ($text) ;
}

sub on_paste_task_activate
{
    my ($self, $w) = @_ ;

    my $clipboard = $w->get_clipboard(Gtk2::Gdk->SELECTION_PRIMARY)  ;
    if($clipboard->wait_is_text_available) {
	my $data =  $clipboard->wait_for_text ;
	if ($data =~ /^<task[^>]+>$/) {
	    &Sched::NS::set_jobid($self->{job_uid}) ;
	    
	    my $xml = new XML::Mini::Document() ;
	    $xml->parse($data) ;

	    $xml = $xml->getRoot()->getElement('task') ;

	    return if (!$xml) ;
	    		      
	    my $id = $xml->attribute('id') ;
	    
	    my $nb = 1 ;
	    while(Sched::NS::aa($id)) {
		$id = $xml->attribute('id') . "_$nb" ;
		$nb++ ;
	    }
	    $xml->attribute('id', $id) ;
	    
	    $self->{xml}->appendChild($xml) ;

	    my $t = new SchedUI::TaskItem(job_uid => $self->{job_uid},
					  xml => $xml);
	    
	    my $group =  Sched::NS::aa('=group=') ;
	    
	    $t->display($group) ;
	    $t->on_properties_task_activate() ;
	    
	    my $l = Sched::NS::aa('=link-xml=') ;
	    $l->add_line_between_obj($self, $t) ;
	}
    }
}

sub update_link
{
    my ($self, $newlink) = @_ ;

    Sched::NS::set_jobid($self->{job_uid}) ;

    my %link = Sched::Cond::how_depend_of($self->{xml}) ;

    my %old_link = %{$self->{_old_link}} ;

    for my $part ( keys %link ) {
	
	if ((exists $old_link{$part}) 
	    and 
	    ($old_link{$part} eq $link{$part})) 
	{
	    delete $old_link{$part} ;
	    next ;
	}

	# nouveaux liens
	# id =aa=> uid =aa=> object
	my $obj = Sched::NS::get_obj($part) ;

	my $l = Sched::NS::aa("=link-cond-$link{$part}=") ;
	
	$l->add_line_between_obj($self, $obj) ;
    }

    # on supprime les anciens
    for my $part ( keys %old_link) {

	my $obj = Sched::NS::get_obj($part) ;

	my $l = Sched::NS::aa("=link-cond-$old_link{$part}=") ;

	$l->remove_line_between_obj($self, $obj) if($obj) ;
    }

    $self->{_old_link} = \%link ;
}

sub _update
{
    my $self = shift ;

    if ($self->id ne $self->{_old_id}) {

	&Sched::NS::set_jobid($self->{job_uid}) ;
	&Sched::NS::rename_id($self->{_old_id}, $self->id) ;

	$self->{_old_id} = $self->id ;
	$self->{label}->set('text', $self->id) ;
    }   

    $self->update_link() ;
}

# TODO : si double click, on affiche les proprietes

sub _task_event {
    my ($item, $event, $self) = @_;
    
    # set item_[xy] to the event x,y position in the parent's
    # item-relative coordinates
    my ($item_x, $item_y) = $item->parent->w2i ($event->coords);
    
    if ($event->type eq 'button-press') {
	if ($event->button == 1) {
	    $self->{tmp_x} = $item_x;
	    $self->{tmp_y} = $item_y;
	    
	    $item->grab ([qw/pointer-motion-mask
			  button-release-mask/],
			 Gtk2::Gdk::Cursor->new ('fleur'),
			 $event->time);
	    
	    $self->{dragging} = Glib::TRUE;
	} elsif ($event->button == 3) {
	    
	    $self->{widget_popup}->popup(undef,
					 undef, 
					 undef,
					 undef,
					 $event->button, $event->time) ;
	} elsif ($event->button == 2) {
	    $self->on_properties_task_activate() ;
	} 
	
    } elsif ($event->type eq 'motion-notify') {
	if ($self->{dragging} && $event->state >= 'button1-mask') {
	    my $new_x = $item_x;
	    my $new_y = $item_y;
	    
	    $item->move ($new_x - $self->{tmp_x},
			 $new_y - $self->{tmp_y});
	    
	    $self->x($self->x + $new_x  - $self->{tmp_x});
	    $self->y($self->y + $new_y  - $self->{tmp_y});

	    Sched::NS::set_jobid($self->{job_uid}) ;

	    for my $type (@SchedUI::link_type) {
		my $l = Sched::NS::aa("=link-cond-$type=") ;
		$l->move_obj($self) ;
	    }

	    my $l = Sched::NS::aa("=link-xml=") ;
	    $l->move_obj($self) ;
	    
	    $self->{tmp_x} = $new_x ;
	    $self->{tmp_y} = $new_y ;
	}
	
    } elsif ($event->type eq 'button-release') {
	$item->ungrab ($event->time);
	$self->{dragging} = Glib::FALSE;
    }
    
    return Glib::FALSE;
}

sub on_add_sub_task_activate
{
    my ($self) = @_ ;

    
    my $nb = 0 ;
    my $xml = $self->{xml} ;


    my $task = $xml->createChild('task') ;
    $task->attribute('id', Sched::NS::get_uid()) ;

    my $t = new SchedUI::TaskItem(job_uid => $self->{job_uid},
				  xml => $task) ;

    Sched::NS::set_jobid($self->{job_uid}) ;
    my $group =  Sched::NS::aa('=group=') ;

    $t->display($group) ;
    $t->on_properties_task_activate() ;

    my $l = Sched::NS::aa('=link-xml=') ;
    $l->add_line_between_obj($self, $t) ;
}

sub on_properties_task_activate
{
    my ($self) = @_ ;

    $self->{_old_link} = { Sched::Cond::how_depend_of($self->{xml}) } ;

    my $p = new SchedUI::TaskEdit($self->uid, $self->{xml}) ;

}

# pixbuf commun a toutes les taches
my $pixmaps ;

sub display
{
    my ($self, $group) = @_ ;

    if (!$self->x) {
	$self->x(145) ;
	$self->y(80) ;
    }

    my $gr = Gnome2::Canvas::Item->new($group,
				       'Gnome2::Canvas::Group',
				       x => $self->x, y => $self->y) ;

    Gnome2::Canvas::Item->new ($gr,
			       'Gnome2::Canvas::Rect',
			       x1 => 0,
			       y1 => 0,
			       x2 => $SchedUI::Item::width,
			       y2 => $SchedUI::Item::heigh,
			       fill_color_rgba => 0x21a37180,
			       outline_color => 'black',
			       width_units => 0.5);

    unless ($pixmaps) {
	$pixmaps = Gtk2::Gdk::Pixbuf->new_from_file($pix_task) ;
    }

    Gnome2::Canvas::Item->new($gr, 'Gnome2::Canvas::Pixbuf',
			 pixbuf => $pixmaps,
			 x => 20*$SchedUI::Item::width/100,
			 y => 10*$SchedUI::Item::heigh/100,
			 ) ;
 
    $self->{label} = Gnome2::Canvas::Item->new ($gr, 'Gnome2::Canvas::Text',
			text => $self->id,
			x => 20*$SchedUI::Item::width/100,
			y => - (25*$SchedUI::Item::heigh/100),
			font => 'Sans 11',
			anchor => 'GTK_ANCHOR_WEST', #GTK_ANCHOR_N,
			fill_color => 'black');

    $gr->signal_connect (event => \&_task_event, $self);

    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, 'menu_task') ;
    $g->signal_autoconnect_from_package($self) ;

    $self->{widget_popup} = $g->get_widget('menu_task') ;
    $self->{widget} = $gr ;

}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

