package SchedUI::TaskEdit ;
use strict ;

use SchedUI::ItemEdit ;
use SchedUI::CondEdit ;

our @ISA = 'SchedUI::ItemEdit' ;

our $version = '$Id: TaskEdit.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

sub new
{
    my ($class, $uid, $xml) = @_ ;

    my $self = $class->SUPER::new($uid, $xml) ;
    bless ($self, $class) ;

    $self->{entry} = ['id', 'host', 'cmdline', 'stdout', 'stderr', 'stdin',
		      'user', 'group', 'use'] ;
    $self->{text} = ['cond', 'comment', 'env', 'after_cmd'] ;
    $self->{spin} = ['maxtime'] ;

    $self->{encode} = ['comment', 'cond', 'cmdline', 'env', 'after_cmd'] ;

    $self->init_use() ;

    $self->init() ;

    return $self ;
}

sub init_use
{
    my ($self) = @_ ;

    # initialisation de la liste des templates
    my $geu = $self->get_widget('gentry_use') ;
    $geu->clear_history() ;

    my $t = SchedUI::Template::get() ;
    map { $geu->append_history(0, $_) } $t->get_all_template() ;
}

sub on_use_info_clicked
{
   my ($self) = @_ ;
   my $id = $self->get_widget('entry_use')->get_text() ;
   
   my $t = SchedUI::Template::get() ;
   $t->template_edit($id) ;
}

sub on_use_changed
{
    my ($self) = @_ ;

#     my $id = $self->get_widget('entry_use')->get_text() ;
#     my $c = SchedUI::Template::get() ;
#     my $t = $c->get_template($id) ;
#     if ($t) {
# 	$self->set_default($t) ;
# 	$self->set_default() ;
#     }
	
}

sub on_cmdline_select_clicked
{
    my ($self) = @_ ;
    my $tedit = SchedUI::Cmd::get() ;
    $tedit->show($self->get_widget('entry_cmdline')) ;
}

sub on_cond_edit_clicked
{
    my ($self) = @_ ;
    my $c = new SchedUI::CondEdit($self->{xml}, 
				  $self->get_widget('text_cond')) ;
}

sub on_use_select_clicked
{
    my ($self) = @_ ;
    my $c = SchedUI::Template::get() ;
    $c->show($self->get_widget('entry_use')) ;
}

sub test
{

}

1;

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

