package SchedUI::CommentItem ;
use strict ;
use integer ;

use MIME::Base64 ;
use Gtk2::GladeXML;
use Gtk2 ;
use Gnome2::Canvas ;
use Glib ;
our $version = '$Id: CommentItem.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Sched::Cond ;

use Sched::NS ;
use SchedUI::Item ;
use SchedUI::CommentEdit ;

our @ISA = 'SchedUI::Item' ;

=head1 PACKAGE SchedUI::CommentItem

    Gestion de l'affichage un Commentaire

=head2 USAGE

    new( xml => XML::Mini::Element || data => <?....?>)

=head2 ATTRIBUTE

    {_old_text}	: permet de mettre a jour le label quand il faut

    {widget} : reference vers le Canvas::Group
    {label} : reference vers le Canvas::Item::Label
    {rect} : reference vers le Canvas::Item::Rect

    &uid : acces au champs uid
    &id  : acces au champs (xml) id
        
=head2 TODO

=cut

sub new
{
    my ($class, %arg) = @_ ;
    
    my $self = bless ({}, $class) ;

    if (exists $arg{xml}) {
	$self->{xml} = $arg{xml} ;
    } elsif (exists $arg{data}) {
	my $xml = new XML::Mini::Document() ;
	$xml->parse($arg{data}) ;
	$xml = $xml->getRoot()->getElement('comment') ;

	if (!$xml) {
	    print "E : impossible d'initialiser $class\n" ;
	    return undef; 
	}
	
	$self->{xml} = $xml ;

    } else {
	print "E : impossible d'initialiser $class\n" ;
	return undef; 
    }
    
    if (not defined $self->{xml}->attribute('id')) {
	$self->{xml}->attribute('id', Sched::NS::get_uid()) ;
    }

    $self->uid(Sched::NS::get_uid()) ;

    Sched::NS::register_id($self->id, $self->uid) ;
    Sched::NS::register_id($self->uid, $self) ;

    Sched::Callback::add_cb("CHANGE $self->{uid}", \&_update, [$self]) ;
    $self->{_old_text} = '' ;

    $self->x($self->x || 10) ;
    $self->y($self->y || 10) ;

    return $self ;
}

sub on_del_activate
{
    my ($self) = @_ ;
    Sched::NS::unregister_id($self->id) ;
    Sched::NS::unregister_id($self->uid) ;
    Sched::Callback::del_cb("CHANGE $self->{uid}") ;
    $self->{label}->destroy() ;
    $self->{rect}->destroy() ;
    $self->{widget_popup}->destroy() ;
    $self->{xml}->remove() ;

    map { delete $self->{$_} } keys %{ $self } ;
}

# TODO : transparence code/decode
my %attr_base64 = map { $_ => 1 } qw/text/ ;

sub attribute
{
    my $self = shift ,
    my ($attr, $val) = @_ ;

    if ($attr_base64{$attr}) {
	if (defined $val) {
	  return $self->{xml}->attribute($attr, 
					 MIME::Base64::encode_base64($val,''));
	} else {
	    my $v = $self->{xml}->attribute($attr) ;

	    if ($v) {
		$v = MIME::Base64::decode_base64($v) ;
	    } 
	    return $v ;
	}
    } else {
	return $self->{xml}->attribute(@_) ;
    }
}

sub to_xml
{
    my $self = shift ;
    my $rep = '<comment ' ;

    for my $a (qw/id text x y/) {
	$rep .= $a . "=" . $self->{xml}->attribute($a) ;
    }

    $rep .= ' />' ;
    return $rep ;
}

sub on_cut_task_activate
{
    my ($self, $w) = @_ ;

    print "E : this function is not yet well implemented...\n" ;
    return ;

    # parcourir toutes les task
    #	    -> copier sur le pere
    #	    -> delete
}

sub on_copy_task_activate
{
    my ($self, $w) = @_ ;

    my $text = $self->to_xml() ;
    my $clipboard = $w->get_clipboard(Gtk2::Gdk->SELECTION_PRIMARY) ;
    $clipboard->set_text ($text) ;
}

sub on_paste_task_activate
{
    my ($self, $w) = @_ ;

    my $clipboard = $w->get_clipboard(Gtk2::Gdk->SELECTION_PRIMARY)  ;
    if($clipboard->wait_is_text_available) {
	my $data =  $clipboard->wait_for_text ;
	if ($data =~ /^<comment[^>]+>$/) {
	}
    }
}

sub _update
{
    my $self = shift ;

    my $text = $self->attribute('text') ;

    if ($text ne $self->{_old_text}) {

	$self->{_old_text} = $text ;
	$self->{label}->set('text', $text) ;
	
	my @l = sort { $b <=> $a } map { length } split(/\n/, $text) ;
	my $len = $l[0] ;

	my ($x, $y) = ($self->x, $self->y) ;
	my $cr = ($text =~ tr/\n//) || 1;
	
	$self->{label}->set('x' => 20 + $len*4,
			    'y' => 15 + $cr*10) ;

	$self->{rect}->set('x1' => 0,
			   'y1' => 0,
			   'x2' => 40 + $len*8,
			   'y2' => 30 + $cr*20) ;
    }   
}

# TODO : si double click, on affiche les proprietes

sub _task_event {
    my ($item, $event, $self) = @_;
    
    # set item_[xy] to the event x,y position in the parent's
    # item-relative coordinates
    my ($item_x, $item_y) = $item->parent->w2i ($event->coords);
    
    if ($event->type eq 'button-press') {
	if ($event->button == 1) {
	    $self->{tmp_x} = $item_x;
	    $self->{tmp_y} = $item_y;
	    
	    $item->grab ([qw/pointer-motion-mask
			  button-release-mask/],
			 Gtk2::Gdk::Cursor->new ('fleur'),
			 $event->time);
	    
	    $self->{dragging} = Glib::TRUE;
	} elsif ($event->button == 3) {
	    
	    $self->{widget_popup}->popup(undef,
					 undef, 
					 undef,
					 undef,
					 $event->button, $event->time) ;
	} 
	
    } elsif ($event->type eq 'motion-notify') {
	if ($self->{dragging} && $event->state >= 'button1-mask') {
	    my $new_x = $item_x;
	    my $new_y = $item_y;
	    
	    $item->move ($new_x - $self->{tmp_x},
			 $new_y - $self->{tmp_y});
	    
	    $self->x($self->x + $new_x  - $self->{tmp_x});
	    $self->y($self->y + $new_y  - $self->{tmp_y});
	    
	    $self->{tmp_x} = $new_x ;
	    $self->{tmp_y} = $new_y ;
	}
	
    } elsif ($event->type eq 'button-release') {
	$item->ungrab ($event->time);
	$self->{dragging} = Glib::FALSE;
    }
    
    return Glib::FALSE;
}

sub on_properties_task_activate
{
    my ($self) = @_ ;

    my $p = new SchedUI::CommentEdit($self->uid, $self->{xml}) ;

}

sub on_properties_activate
{
    my ($self) = @_ ;

    my $p = new SchedUI::CommentEdit($self->uid, $self->{xml}) ;
}

sub display
{
    my ($self, $group) = @_ ;

    my $gr = Gnome2::Canvas::Item->new($group,
				       'Gnome2::Canvas::Group',
				       x => $self->x, y => $self->y) ;

    $self->{rect} = Gnome2::Canvas::Item->new ($gr,
					       'Gnome2::Canvas::Rect',
					       fill_color_rgba => 0xffff0080,
					       outline_color => 'black',
					       width_units => 1.0);


    $self->{label} = Gnome2::Canvas::Item->new ($gr, 'Gnome2::Canvas::Text',
			font => 'Sans 11',
			#anchor => 'GTK_ANCHOR_WEST', #GTK_ANCHOR_N,
			fill_color => 'black');

    $self->_update() ;

    $gr->signal_connect (event => \&_task_event, $self);

    my $g = Gtk2::GladeXML->new($SchedUI::glade_file, 'menu_comment') ;
    $g->signal_autoconnect_from_package($self) ;

    $self->{widget_popup} = $g->get_widget('menu_comment') ;
    $self->{widget} = $gr ;

}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

