package SchedUI::Cmd ;
use strict ;

our $version = '$Id: Cmd.pm,v 1.1 2005/04/05 19:45:18 mcgregor Exp $' ;

use Gtk2::GladeXML ;
use XML::Mini ;
use MIME::Base64 qw/encode_base64 decode_base64/;
use SchedUI ;
use Sched::NS ;
#use SchedUI::CmdEdit ;
use Sched::Callback ;
my $cmd_list ;

sub load_cmd_list
{
    my $xml = new XML::Mini::Document() ;
    $xml->parse($SchedUI::cmd_file) ;

    $xml = $xml->getRoot()->getElement('cmdlist') ;

    if (!$xml) {
	return ;
    }
    $cmd_list = $xml ;
}

sub on_save_clicked
{
    my ($self) = @_ ;

    print $cmd_list->toString() if ($cmd_list) ;
}

sub new
{
    my ($class) = @_ ;

    my $self = { 
	uid => Sched::NS::get_uid(),
	current => 0,
	} ;
    
    bless ($self, $class) ;

    my $g = new Gtk2::GladeXML($SchedUI::glade_file, 'dlg_cmd') ;
    $self->{glade} = $g ;

    $g->signal_autoconnect_from_package($self) ;

    my $simplelist = Gtk2::SimpleList->new_from_treeview (
                           $g->get_widget('treeview_cmdline'),
                           'Command name'   => 'text',
                           'Comment'        => 'text',
                        );
    
    $self->{slist} = $simplelist ; 

    load_cmd_list() if (!$cmd_list) ;

    $self->_update() ;
    
    return $self ;
}
#ici
sub get_cmd($$)
{
    my ($self, $name) = @_;

    for my $c (@{ $cmd_list->getAllChildren('cmd') }) {
	if ($c->attribute('name') eq $name) {
	    return $c ;
	}
    }

    return undef ;
}

sub on_cmdline_row_activated
{
    my $self = shift ;

    my ($sel, $name) = $self->get_selection() ;
    return if (!defined $sel || !$name) ;

    my $c = $self->get_cmd($name) ;

    $self->{current} = $sel ; 

    my $w = $self->{glade}->get_widget('entry_name') ;
    $w->set_text($c->attribute('name')) ;
    
    $w = $self->{glade}->get_widget('entry_cmdline') ;
    $w->set_text(decode_base64($c->attribute('cmdline'))) ;

    $w = $self->{glade}->get_widget('text_comment') ;
    my $b = new Gtk2::TextBuffer() ;
    $b->set_text(decode_base64($c->attribute('comment'))) ;
    $w->set_buffer($b) ;
}

sub get
{
    my $self = Sched::NS::aa('=command=') ;
    
    if (!$self) {
	$self = new SchedUI::Cmd();
	Sched::NS::register_id('=command=', $self) ;
    }
    return $self ;
}

sub show
{
    my ($self, $entry) = @_ ;

    $self->_update() ;
    $self->{glade}->get_widget('dlg_cmd')->show() ;

    my $w = $self->{glade}->get_widget('entry_name') ;
    $w->set_text('') ;
    
    $w = $self->{glade}->get_widget('entry_cmdline') ;
    $w->set_text('') ;

    $w = $self->{glade}->get_widget('text_comment') ;
    my $b = new Gtk2::TextBuffer() ;
    $b->set_text('') ;
    $w->set_buffer($b) ;

    $self->{entry} = $entry if ($entry) ;
}

sub _update
{
    my $self = shift ;

    @{$self->{slist}->{data}} = () ;
    
    for my $c (@{ $cmd_list->getAllChildren('cmd') }) {
	if ($c->attribute('name') ne '') {
	    push @{$self->{slist}->{data}}, [$c->attribute('name'),
			    decode_base64($c->attribute('comment'))] ;
	}

    }
}

sub reset
{
    my ($self, $xml) = @_ ;

    my $w = $self->{glade}->get_widget('entry_name') ;
    $w->set_text('') ;
    
    $w = $self->{glade}->get_widget('entry_cmdline') ;
    $w->set_text('') ;

    $w = $self->{glade}->get_widget('text_comment') ;
    my $b = new Gtk2::TextBuffer() ;
    $b->set_text('') ;
    $w->set_buffer($b) ;
}

sub have_name
{
    my ($self) = @_ ;
    my $w = $self->{glade}->get_widget('entry_name') ;
    return $w->get_text() ;
}

sub set_data
{
    my ($self, $xml) = @_ ;

    my $w = $self->{glade}->get_widget('entry_name') ;

    my $txt = $w->get_text() ;
    $txt =~ s/[^\w\d\s\(\)\[\]\.-]//g ;
    $xml->attribute('name', $txt) ;
    
    $w = $self->{glade}->get_widget('entry_cmdline') ;
    $xml->attribute('cmdline', encode_base64($w->get_text(), '')) ;

    $w = $self->{glade}->get_widget('text_comment') ;
    my $b = $w->get_buffer() ;
    my $s = $b->get_iter_at_offset(0) ;
    my $e = $b->get_iter_at_offset(-1) ;

    my $t = $b->get_text($s, $e, 1) ;
    
    $t = encode_base64($t, '') ;
    $xml->attribute('comment', $t) ;
}

sub get_selection
{
    my ($self) = @_ ;

    # recuperation de l'indice
    my @indices = $self->{slist}->get_selected_indices() ;
    # on ne prend que le premier
    my $sel = pop @indices ;
    $sel = $self->{current} if (not defined $sel) ;

    return undef if (!defined $sel) ;

    # recuperation de l'id
    return ($sel, $self->{slist}->{data}[$sel][0]);
}

sub on_apply_clicked
{
    my $self = shift ;

    return if (!$self->have_name()) ;

    my ($sel, $name) = $self->get_selection() ;
    my $c = $self->get_cmd($name) ;

    $self->set_data($c) ;

    return if ($c->attribute('name') eq "") ;

    $self->{slist}->{data}[$sel] = [ $c->attribute('name'), 
				     decode_base64($c->attribute('comment'))] ;
}

sub on_add_clicked
{
    my $self = shift ;

    return if (!$self->have_name()) ;

    my $c = $cmd_list->createChild('cmd') ;
    $cmd_list->attribute('name', Sched::NS::get_uid()) ;

    $self->set_data($c) ;

    push @{$self->{slist}->{data}}, [$c->attribute('name'),
				     decode_base64($c->attribute('comment'))] ;
    $self->reset() ;
}

sub on_remove_clicked
{
    my $self = shift ;

    # on supprime pas le dernier
    $self->{current} = undef ;

    my ($sel, $name) = $self->get_selection() ;

    return if (!defined $sel || !$name) ;

    # suppression du noeud XML::Smart
    for my $c (@{ $cmd_list->getAllChildren('cmd') }) {
	if ($c->attribute('name') eq $name) {
	    splice @{ $self->{slist}->{data} }, $sel, 1;
	    $cmd_list->removeChild($c) ;
	    return ;
	}
    }
}

sub on_close_clicked
{
    my ($self) = @_ ;

    delete $self->{entry} ;
    my $w = $self->{glade}->get_widget('dlg_cmd') ;
    $w->hide() ;
}

sub get_current_cmdline
{
    my ($self) = @_ ;

    my $name = $self->get_current_cmd() ;
    my $c = $self->get_cmd($name) ;

    return $c->attribute('cmdline') ;
}

sub get_current_cmd
{
    my ($self) = @_ ;
    # recuperation de l'indice
    my @indices = $self->{slist}->get_selected_indices() ;
    # on ne prend que le premier
    my $sel = pop @indices ;

    return undef if (!defined $sel) ;

    # recuperation de l'id
    return $self->{slist}->{data}[$sel][0];
}

sub on_ok_clicked
{
    my ($self) = @_ ;

    if ($self->{entry}) {
	$self->{entry}->set_text(decode_base64($self->get_current_cmdline()));
    }

    $self->on_close_clicked() ;
}

sub test
{

}

1;

__END__

=head1 AUTHOR

(C) 2004-2005 Eric Bollengier

You may reach me through the contact info at eric@eb.homelinux.org

=head1 LICENSE

    Part of the network scheduling system (Sched)
    Copyright (C) 2004-2005 Eric Bollengier
        All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

