;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(defpackage :edu.unm.hpc.Scat.Nodeset
  (:nicknames :Scat.Nodeset)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :scat.lib))

(in-package :Scat.Nodeset)

(defun toplevel () 
  (sb-sys:enable-interrupt sb-unix:SIGINT #'handle-ctrl-c)
  (read-scat-config)
  (if (equal (length (rest sb-ext:*posix-argv*)) 2)
      (let ((command (cadr (rest sb-ext:*posix-argv*)))
            (nodes (expand-nodelist (car (rest sb-ext:*posix-argv*)))))
        (cond ((cmd= command :STAT)
               (apply #'do-stat nodes))
              (t
               (apply #'change-state command nodes)))
        (cl-user::quit))
      (progn
        (warn "bad number of arguments you loser... bailing")
        (cl-user::quit))))

(defun do-stat (&rest nodes)
  "print the state of the named nodes"
  (let ((max (+ 5  (loop as node in nodes maximize (length node)))))
    (format t "~A" 
            (with-output-to-string (s)
              (mapcar
               (lambda (node)
                 (let ((state 
                        (restart-case (node-state node)
                          (ignore-bogus-node () NIL))))
                   (when state
                     (format s "~A~VT~A~%" node max state))))
               nodes)))))

;;;; this stuff should be generalized... 
;;;; I should be able to define my own states
;;;; thats for at least 0.0.2

(defun change-state (state &rest nodes)
  "set the named nodes state to the given state"
  (mapcar
   (lambda (node)
     (set-state node state))
   nodes))

(defun do-boot (&rest nodes)
  "set tne named nodes state to boot"
  (mapcar
   (lambda (node)
     (set-state node "boot"))
   nodes))

(defun do-install (&rest nodes)
  "set tne named nodes state to install"
  (mapcar
   (lambda (node)
     (set-state node "install"))
   nodes))
