;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

(defpackage :edu.unm.hpc.Scat.Nodeset
  (:nicknames :Scat.Nodeset)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :cl-cli
        :Scat.Lib
        ))

(in-package :edu.unm.hpc.Scat.Nodeset)

(defvar *opts* 
  (list
   (make-instance 'cli-opt
                  :name "help"
                  :arguments ()
                  :action
                  #'(lambda ()
                      (progn
                        (org.prewett.cl-cli::help *opts*)
                        (cl-user::quit)))
                  :description "display this help text")
   (make-instance 'cli-opt
                  :name :default
                  :arguments '(noderange command)
                  :action
                  #'(lambda (noderange command)
                      (setf *nodes* (Scat.Lib::expand-nodelist noderange)
                            *command* (string-upcase command))))))

(defvar *nodes* ())
(defvar *command* ())

(defun toplevel () 
  (scat.lib::read-scat-config)
  (cl-cli::process-options *opts* (rest sb-ext:*posix-argv*))

  (cond ((equal *command* "STAT")
         (apply #'do-stat *nodes*))
        ((equal *command* "BOOT")
         (apply #'do-boot *nodes*))
        ((equal *command* "INSTALL")
         (apply #'do-install *nodes*))
        (t
         (error "unknown command: ~A" command)))
  (cl-user::quit))

(defun do-stat (&rest nodes)
  "print the state of the named nodes"
  (format t "~A" 
          (with-output-to-string (s)
            (mapcar
             (lambda (node)
               (let ((state 
                      (restart-case (node-state node)
                        (ignore-bogus-node () NIL))))
                 (when state
                   (format s "~A: ~A~%" node state))))
             nodes))))

;;;; this stuff should be generalized... 
;;;; I should be able to define my own states
;;;; thats for at least 0.0.3
(defun do-boot (&rest nodes)
  "set tne named nodes state to boot"
  (set-node-states nodes "boot"))

(defun do-install (&rest nodes)
  "set tne named nodes state to install"
  (set-node-states nodes "install"))
