;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(require 'asdf)
(require 'ltk)

(defpackage :edu.unm.hpc.Scat.nodesetGUI
  (:USE :common-lisp :ltk :edu.unm.hpc.scat.lib)
  )

(in-package :edu.unm.hpc.Scat.nodesetGUI)

(use-package :ltk)

(defun toplevel()
  (scat.lib::read-scat-config)
  (let ((nodes (edu.unm.hpc.scat.lib::list-node-files)))
    (with-ltk ()
      (loop as node in nodes
           do
           (pack (make-instance 'label :text node))
           (pack (make-instance 'button :image "boot.bmp"))))
    (cl-user::quit)))

;; (defun toplevel()
;;   (scat.lib::read-scat-config)
;;   (let ((nodes (edu.unm.hpc.scat.lib::list-node-files)))
;;     (with-ltk ()
;;       (mapcar 
;;        (lambda (widget)
;;          (pack widget))
;;        (mapcar 
;;         (lambda (x)
;;           (make-instance 'label
;;                          :text x))
;;         nodes)))
;;     (cl-user::quit)))