;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(defpackage :edu.unm.hpc.Scat.nodels
  (:nicknames :Scat.nodels)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :Scat.Lib
        ))

(in-package :edu.unm.hpc.Scat.nodels)

(defun toplevel () 
  (read-scat-config)
  (if (equal (length (rest sb-ext:*posix-argv*)) 1)
      (let* ((nodes 
              (scat.noderange::expand-nodelist 
               (car (rest sb-ext:*posix-argv*)))))
        (Scat.Noderange::print-noderange t nodes)
        (cl-user::quit))
      (progn
        (warn "expected: noderange")
        (sb-ext::quit))))