;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(defpackage :edu.unm.hpc.Scat.create-node
  (:nicknames :Scat.create-node)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :Scat.Lib
        ))

(in-package :edu.unm.hpc.Scat.create-node)

(defun toplevel () 
  (read-scat-config)
  (if (equal (length (rest sb-ext:*posix-argv*)) 3)
      (let ((node (car (rest sb-ext:*posix-argv*)))
            (mac 
             (format () "01-~A" 
                     (cl-ppcre:regex-replace-all 
                      ":" 
                      (string-downcase (car (cdr (rest sb-ext:*posix-argv*))))
                      "-")))
            (state (string-upcase 
                    (car (cdr (cdr (rest sb-ext:*posix-argv*)))))))
        (format t "node: ~A mac: ~A state: ~A ~%" 
                node mac state)
        (set-state node (string-downcase state))
        (name-mac mac node)
        (cl-user::quit))
      (progn
        (warn "expected name MAC state")
        (sb-ext::quit))))