;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

(defpackage :edu.unm.hpc.Scat.expandtree
  (:nicknames :Scat.expandtree)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :Scat.Lib
        :cl-cli
        ))

(in-package :edu.unm.hpc.Scat.expandtree)

(defvar *opts* 
  (list
   (make-instance 'cli-opt
                  :name "help"
                  :arguments ()
                  :action
                  #'(lambda ()
                      (org.prewett.cl-cli::help *opts*)
                      (cl-user::quit))
                  :description "display this help text")
   (make-instance 'cli-opt
                  :name :default
                  :arguments '(orig new &rest args)
                  :action
                  #'(lambda (orig new &rest args)
                      (setf scat.lib::*macro-table*
                            (loop as pair in args
                                  collect (cl-ppcre::split "=" pair)))
                        (scat.lib::copy-directory-tree orig new)))))

(defun toplevel () 
  ;; (read-scat-config)
  (cl-cli::process-options *opts* (rest sb-ext:*posix-argv*))
  (cl-user::quit))
