;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


(defpackage :edu.unm.hpc.Scat.Noderange
  (:nicknames :Scat.Noderange)
  (:use :cl
          #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user)
  (:export split-name
           noderange))

(in-package :edu.unm.hpc.Scat.Noderange)

(defun split-name (name)
  (multiple-value-bind
        (matches sub-matches)
    (cl-ppcre::scan-to-strings
     "([^0-9]+)([0-9]+)"
     name)
    sub-matches))

(defun noderange (start end)
  (let* ((start (split-name start))
         (start-name (aref start 0))
         (start-num (aref start 1))
         (start-num-len (length start-num))
         (end (split-name end))
         (end-name (aref end 0))
         (end-num (aref end 1))
         (end-num-len (length end-num)))
    ;; some error checking
    (when (not 
           (eql start-num-len
                end-num-len))
      (error "numeric padding issue!"))
    (when (not 
           (string-equal
            start-name
            end-name))
      (error "name mis-match!"))
    (loop for count 
          from (read-from-string start-num)
          to (read-from-string end-num)
          collect
          (format () 
                  "~A~v,'0d"
                  start-name
                  start-num-len
                  count))))

(defun print-noderange (stream nodes)
  (format stream "~{~A~%~}" nodes))

(defun expand-nodelist (nodelist)
  (remove-duplicates
   (mapcan
    (lambda (thing)
      (if (cl-ppcre::scan "-" thing)
          (apply #'noderange (cl-ppcre::split "-" thing))
          (list thing)))
    (cl-ppcre::split "," nodelist))
   :test #'equal))
