;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(defpackage :edu.unm.hpc.Scat.create-node
  (:nicknames :Scat.create-node)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        ))

(in-package :edu.unm.hpc.Scat.create-node)

(defun node-full-path (name)
  "given the name of a node, return the path where we expect its boot control file to be"
  (merge-pathnames Scat.Cfg::*pxe-config-dir* name))

(defun state-full-path (name)
  "given the name of a node state, return the path where we expect its boot control file to be"
  (merge-pathnames Scat.Cfg::*pxe-config-dir* name))

(defun mac-full-path (mac)
  "given the name of a node state, return the path where we expect its boot control file to be"
  (merge-pathnames Scat.Cfg::*pxe-config-dir* mac))

(defun state-existsp (name)
  "return the truename of the state file and its filename"
  (let ((full-name (state-full-path name)))
    (values
     (probe-file full-name)
     full-name)))

(defun set-state (name state)
  "set the state of a node"
  (let ((state-file (state-existsp state))
        (node-file (node-full-path name)))
    (unless state-file
      (error "bad state: ~A" state-file))
    (sb-posix:symlink state-file node-file)))

(defun name-mac (mac node)
  "link a node name to a mac address"

  (let ((node-full-path (node-full-path node))
        (mac-full-path (mac-full-path mac)))
    (sb-posix:symlink node-full-path mac-full-path)))

(defun toplevel () 
  (Scat.Cfg::read-configuration-file 
   (merge-pathnames 
    #p"etc/Scat.cfg"
    (or
     (sb-posix:getenv "SCAT_ROOT")
     (error "SCAT_ROOT environment variable is unset"))))
  
  (if (equal (length (rest sb-ext:*posix-argv*)) 3)
   (let ((node (car (rest sb-ext:*posix-argv*)))
         (mac 
          (format () "01-~A" 
                  (cl-ppcre:regex-replace-all 
                   ":" 
                   (string-downcase (car (cdr (rest sb-ext:*posix-argv*))))
                   "-")))
         (state (string-upcase (car (cdr (cdr (rest sb-ext:*posix-argv*)))))))
     (format t "node: ~A mac: ~A state: ~A ~%" 
             node mac state)
     (set-state node (string-downcase state))
     (name-mac mac node)
     (cl-user::quit))
   (progn
     (warn "bad number of arguments you loser... bailing")
     (sb-ext::quit))))