<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php 4977 2005-11-15 17:38:40Z yeupou $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2001 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require "../include/pre.php";

# pre.php defeines group to group_id, so do check, else look at request
$group_id = $group_id ? $group_id : $_REQUEST['group_id'];

# Get everything else from REQUEST
$category_id = $_REQUEST['category_id'];

if ($group_id)
{

  site_project_header(array('title'=>_('Project Help Wanted'),'group'=>$group_id,'context'=>'people'));


  # we get site-specific content
  utils_get_content("people/index_group");

  print people_show_project_jobs($group_id);

}
else if ($category_id)
{

# Do check first
$cat_name = people_get_category_name($category_id);

if ($cat_name == 'Invalid ID')
	{
		print site_header(array('title' =>_('Project Help Wanted'), 'context'=>_('people')));

		fb(_("Invalid category: that category does not exist"),1);
	} else {
		print site_header(array('title'=>sprintf(_('Projects looking for %s'), $cat_name), 'context'=>_('people')));


  # we get site-specific content
  utils_get_content("people/index_cat");

  print people_show_category_jobs($category_id);
}

}
else
{

  print site_header(array('title'=>_('Projects Needing Help'), 'context'=>_('people')));


  # we get site-specific content
  utils_get_content("people/index");

  print people_show_category_table();

}

site_project_footer(array());

?>
