<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: format.php 5187 2005-12-01 16:22:29Z yeupou $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2005 (c) Mathieu Roy <yeupou--gnu.org>
#                          Yves Perrin <yves.perrin--cern.ch>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


function format_item_details ($item_id, $group_id, $ascii=false, $item_assigned_to=false,$quoted=false)
{
  ## ASCII must not be translated
  

  #  Format the details rows from trackers_history
  global $sys_datefmt;

  if (!$ascii && user_get_preference("reverse_comments_order"))
    { $result = trackers_data_get_followups($item_id, false); }
  else 
    { $result=trackers_data_get_followups($item_id); }
  $rows=db_numrows($result);

  # No followup comment -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	$out = "";
      else
	$out = '<font class="warn">'._("No Followups Have Been Posted").'</font>';
      return $out;
    }

  # Header first
  if ($ascii)
    {
      $out .= "    _______________________________________________________\n\nFollow-up Comments:\n\n";
    }
  else
    {
      $title_arr=array();
      $title_arr[]=_("Comment");
      $title_arr[]=_("Posted By");
      
      $out .= html_build_list_table_top ($title_arr);
    }
    
  # Loop throuh the follow-up comments and format them
  for ($i=0; $i < $rows; $i++)
    {
	
      $comment_type = db_result($result, $i, 'comment_type');
      if ($comment_type == 'None') 
	{ $comment_type = ''; }
      else
	{ $comment_type = '['.$comment_type.']'; }
	
      if ($ascii)
	{
	  $fmt = "\n-------------------------------------------------------\n".
	     "Date: %-30sBy: %s\n";
	  if ($comment_type)
	    { $fmt .= "%s\n%s"; }
	  else
	    { $fmt .= "%s%s"; }
	  $fmt .= "\n";
	}
    	
      # I wish we had sprintf argument swapping in PHP3 but
      # we dont so do it the ugly way...
      if ($ascii)
	{
          if (db_result($result, $i, 'realname'))
            {
              $name = db_result($result, $i, 'realname')." <".db_result($result, $i, 'user_name').">";
            }
          else 
            {
              $name = "Anonymous"; # must no be translated, part of mails notifs
				     }
	  $out .= sprintf($fmt,
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  $name,
			  $comment_type,
			  utils_unconvert_htmlspecialchars(db_result($result, $i, 'old_value'))
			  );
	}
      else
	{
	  if ($comment_type)
	    {
	      # put the comment type in bold
	      $comment_type = '<font class="bold">'.$comment_type.'</font><br />';
	    } 
	  
	  if (!user_get_preference("reverse_comments_order"))
	    {
	      $comment_number = ($rows-$i);
	    }
	  else
	    {
	      $comment_number = ($i+1);
	    }

          $class = utils_get_alt_row_color($i);
	  unset($icon, $assignee);

	  # Find out the user id of the comment author
	  $poster_id = user_getid(db_result($result, $i, 'user_name'));
	  
	  # Ignore user 100 (anonymous)
	  if ($poster_id != 100)
	    {

	      # Cosmetics if the user is assignee
	      if ($item_assigned_to == db_result($result, $i, 'user_name'))
		{
		  # Highlight the latest comment of the assignee
		  if ($previous != 1)
		    {
		      $class = "boxhighlight"; 
		      $previous = 1; 
		    }
		  
		  $assignee = 1;
		}
	      
	      # Cosmetics if the user is project member (we wont go as far
              # as presenting a different icon for specific roles, like
	      # manager etc..
							
	      if (member_check($poster_id, $group_id, 'A'))
		{
		  # Project admin case: if the group is the admin group,
		  # show the specific site admin icon
		  if ($group_id == $GLOBALS[sys_group_id])
		    {
		      $icon = "site-admin";
		      $icon_alt = _("Site Administrator");
		    }
		  else
		    {
		      $icon = "project-admin";
		      $icon_alt = _("Project Administrator");
		    }
		}
	      elseif (member_check($poster_id, $group_id))
		{
		  # Simple project member
		  $icon = "project-member";
		  $icon_alt = _("Project Member");
		}
	    }

	      if (! $quoted) 
		{
		  $out .= "\n".'<tr class="'.$class.'"><td valign="top"><a name="comment'.$comment_number.'" href="#comment'.$comment_number.'" class="preinput">'.format_date($sys_datefmt,db_result($result, $i, 'date')).', '.sprintf(_("comment #%s:"), $comment_number).'</a>'.$comment_type.'<p>'.utils_make_links(nl2br(db_result($result, $i, 'old_value'))).'</p>'.'</td>';
		  $out .= '<td valign="top" align="center">'.utils_user_link(db_result($result, $i, 'user_name'),db_result($result, $i, 'realname'));
		}
	      else
		{
		  $out .= "\n".'<tr class="'.$class.'"><td valign="top"><a name="comment'.$comment_number.'" href="#comment'.$comment_number.'" class="preinput">'.format_date($sys_datefmt,db_result($result, $i, 'date')).', '.sprintf(_("comment #%s:"), $comment_number).'</a>'.$comment_type.'<p>'.utils_make_links(nl2br(str_replace("\n", "> ", wordwrap("\n".db_result($result, $i, 'old_value'), 78, "\r\n")))).'</p>'.'</td>';
		  $out .= '<td valign="top" align="center">'.utils_user_link(db_result($result, $i, 'user_name'),db_result($result, $i, 'realname'));
		}

          if ($icon)
	    {
	      $out .= '<br /><font class="help" title="'.$icon_alt.'"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.$icon.'.png" alt="'.$icon_alt.'" /></font>';
	    }
	  
	  if ($assignee)
	    {
	      $out .= '<font class="help" title="'._("In charge of this item.").'"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/assignee.png" alt="'._("In charge of this item.").'" /></font>';
	    }
	  
	  $out .= '</td></tr>';

	}
    }

  # final touch...
  $out .= ($ascii ? "\n\n\n" : "</table>");

  return($out);
}



function format_item_changes ($changes,$item_id,$group_id)
{


  # ASCII must not be translated

  global $sys_datefmt;

  # FIXME: strange, with %25s it does not behave exactly like
  # trackers_field_label_display
  $fmt = "%24s: %23s => %-23s\n";

  $separator = "\n    _______________________________________________________\n\n";

  # Process most of the fields
  reset($changes);
  while (list($field,$h) = each($changes))
    {

      # If both removed and added items are empty skip - Sanity check
      if (!$h['del'] && !$h['add'])
	{ continue; }

      if ($field == "details" || $field == "attach") 
        { continue; }

      # Since details is used for followups (creepy!), we are forced to play
      # with "realdetails" non existant field.
      if ($field == "realdetails")
        { $field = "details"; }
     
      $label = trackers_data_get_label($field);
      if (!$label)
	{ $label = $field; }
      $out .= sprintf($fmt, $label, $h['del'],$h['add']);
    }

  if ($out)
    {
      $out = "Update of ".utils_get_tracker_prefix(ARTIFACT)." #".$item_id." (project ".group_getunixname($group_id)."):\n\n".$out;
    }


  # Process special cases: follow-up comments
  if ($changes['details'])
    {

      if ($out)
        { $out .= $separator; }

      $out_com = "Follow-up Comment #".db_numrows(trackers_data_get_followups($item_id));
      if (!$out)
        { 
          $out_com .= ", ".utils_get_tracker_prefix(ARTIFACT)." #".$item_id." (project ".group_getunixname($group_id).")";
        }

      $out_com .= ":\n\n";
      if ($changes['details']['type'] != 'None' && $changes['details']['type'] != '(Error - Not Found)')
	{
	  $out_com .= '['.$changes['details']['type']."]\n";
	}
      $out_com .= utils_unconvert_htmlspecialchars($changes['details']['add']);
      unset($changes['details']);

      $out .= $out_com;
    }


  # Process special cases: file attachment
  if ($changes['attach'])
    {
      if ($out)
        { $out .= $separator; }

      $out_att = "Additional Item Attachment";
      if (!$out)
        { 
          $out_att .= ", ".utils_get_tracker_prefix(ARTIFACT)." #".$item_id." (project ".group_getunixname($group_id).")";
        }
      $out_att .= ":\n\n";
      $out_att .= sprintf("File name: %-30s Size:%d KB\n",$changes['attach']['name'],
			  intval($changes['attach']['size']/1024) );
      $out_att .= $changes['attach']['description']."\n".'<'.$changes['attach']['href'].'>';
      unset($changes['attach']);

      $out .= $out_att;
    }

  return $out;

}


function format_item_attached_files ($item_id,$group_id,$ascii=false,$sober=false)
{

  global $sys_datefmt, $HTML;

  # ASCII must not be translated

  if (!$sober)
    {
      $result=trackers_data_get_attached_files($item_id);
    }
  else
    {
      # In sober output, we assume that files are interesting in their
      # chronological order.
      # For instance, on the cookbook, if screenshots are provided, the author
      # of the item is likely to have posted them in the order of their use.
      # On the other hand, on non-sober output, what matters is the latest
      # submitted item.
      $result=trackers_data_get_attached_files($item_id, 'ASC');
    }
  $rows=db_numrows($result);

  # No file attached -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	$out = "";
      else
	$out = '<font class="warn">'._("No files currently attached").'</font>';
      return $out;
    }

  # Header first
  if ($ascii)
    {
      $out .= "    _______________________________________________________\n\nFile Attachments:\n\n";
    }
  else
    {	
      if (!$sober)
	{
	  $out .= $HTML->box_top(_("Attached Files"),'',1);
	}
    }
  
  # Determine what the print out format is based on output type (Ascii, HTML
  if ($ascii)
    {
      $fmt = "\n-------------------------------------------------------\n".
	 "Date: %s  Name: %s  Size: %s   By: %s\n%s\n%s";
    }

  # Loop throuh the attached files and format them
  for ($i=0; $i < $rows; $i++)
    {

      $item_file_id = db_result($result, $i, 'file_id');
      if ($ascii)
	{
	  $href = $GLOBALS['sys_home'].ARTIFACT."/download.php?file_id=$item_file_id";
	}
      else
	{
	  $href = $GLOBALS['sys_home'].ARTIFACT."/download.php?file_id=$item_file_id";
	}
      
      if ($ascii)
	{
	  $out .= sprintf($fmt,
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  db_result($result, $i, 'filename'),
			  utils_filesize(0, intval(db_result($result, $i, 'filesize'))),
			  db_result($result, $i, 'user_name'),
			  db_result($result, $i, 'description'),
			  '<http://'.$GLOBALS['sys_default_domain'].utils_unconvert_htmlspecialchars($href).'>');
	}
      else
	{
	  unset($html_delete);
	  if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2') && !$sober) 
	    {
	      $html_delete = '<span class="trash"><a href="'.$PHP_SELF.'?func=delete_file&amp;item_id='.$item_id.'&amp;item_file_id='.$item_file_id.'">'.
		'<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" class="icon" alt="'._("Delete").'" /></a></span>';
	    }

	  
	  if (!$sober)
	    {
	      $out .= '<div class="'.utils_get_alt_row_color($i).'">'.$html_delete;
	    }
	  else
	    {
	      $out .= '<div>&nbsp&nbsp;&nbsp;- ';
	    }
	  
	  $out .= '<a href="'.$href.'">file #'.$item_file_id.'</a>'._(": ").'&nbsp;';

	  if (!$sober)
	    {
	      $out .= sprintf(_('%s added by %s'), '<a href="'.$href.'">'.db_result($result, $i, 'filename').'</a>', utils_user_link(db_result($result, $i, 'user_name')));
	    }
	  else
	    {
	      $out .= '<a href="'.$href.'">'.db_result($result, $i, 'filename').'</a>';
	    }

	  $out .= ' <font class="smaller">('.utils_filesize(0, intval(db_result($result, $i, 'filesize')));
	  
	  if (db_result($result, $i, 'filetype'))
	    {
	      $out .= ' - '.db_result($result, $i, 'filetype');
	    }

	  if (db_result($result, $i, 'description'))
	    {
	      $out .= ' - '.utils_make_links(db_result($result, $i, 'description'));
	    }
	  $out .= ')</font></div>';							    
	}
    }
								 
  # final touch...
								 
  if ($ascii || $sober)
  {
    $out .= "\n";
  }
  else
  {
    $out .= $HTML->box_bottom(1);
  }

  return($out);

}



function format_item_cc_list ($item_id,$group_id, $ascii=false)
{
# ASCII must not be translated
  global $sys_datefmt, $HTML;

  /*
          show the files attached to this bug
  */

  $result=trackers_data_get_cc_list($item_id);
  $rows=db_numrows($result);

  # No file attached -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	{
	  $out .= ""; 
	}
      else
	{
	  $out = '<font class="warn">'._("CC list is empty").'</font>';
	}
      return $out;
    }

  # Header first an determine what the print out format is
  # based on output type (Ascii, HTML)
  if ($ascii)
    {
      $out .= "    _______________________________________________________\n\n"."Carbon-Copy List:\n\n";
      $fmt = "%-35s | %s\n";
      $out .= sprintf($fmt, 'CC Address', 'Comment');
      $out .= "------------------------------------+-----------------------------\n";
    }
  else
    {	
      $out .= $HTML->box_top(_("Carbon-Copy List"),'',1);
    }

  # Loop through the cc and format them
  for ($i=0; $i < $rows; $i++)
    {

      $email = utils_antispam_email(db_result($result, $i, 'email'));
      $item_cc_id = db_result($result, $i, 'bug_cc_id');

      # If the CC is a user point to its user page.
      # Do not build mailto, we do not need to help spammers.
      $res_username = user_get_result_set_from_unix($email);
      if ($res_username && (db_numrows($res_username) == 1))
	{ $href_cc = utils_user_link($email); }
      else
	{ $href_cc = $email; }

      if ($ascii)
	{
	  $out .= sprintf($fmt, $email, db_result($result, $i, 'comment'));
	}
      else
	{

	  # show CC delete icon if one of the condition is met:
	  # a) current user is a tracker manager
	  # b) then CC name is the current user 
	  # c) the CC email address matches the one of the current user
	  # d) the current user is the person who added a given name in CC list
	  if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2') ||
	      (user_getname(user_getid()) == $email) ||  
	      (user_getemail(user_getid()) == $email) ||
	      (user_getname(user_getid()) == db_result($result, $i, 'user_name') ))
            {
$html_delete = '<span class="trash"><a href="'.$PHP_SELF.'?func=delete_cc&amp;item_id='.$item_id.'&amp;item_cc_id='.$item_cc_id.'">'.
		 '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" class="icon" alt="'._("Delete").'" /></a></span>';
	    }
	  else
	    {
	      $html_delete = '';
	    }
            
          $out .= '<li class="'.utils_get_alt_row_color($i).'">'.$html_delete.
	  sprintf(_('%s added by %s'), $email, utils_user_link(db_result($result, $i, 'user_name')));
          if (db_result($result, $i, 'comment'))
           {
	     $out .= ' <font class="smaller">('.utils_make_links(db_result($result, $i, 'comment')).')</font>';
           }

#$href_cc,
#			  format_date($sys_datefmt,db_result($result, $i, 'date')),
#			  $html_delete);
        }
    }

  # final touch...
  $out .= ($ascii ? "\n" : $HTML->box_bottom(1));

  return($out);

}

?>
