<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: lastlogins.php,v 1.12 2005/06/30 17:19:33 toddy Exp $
//
//
// 
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2001 (c) Free Software Foundation
// 
// The Savane project is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// The Savane project is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with the Savane project; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
//
//

require "../include/pre.php";
site_admin_header(array('title'=>_("Most Recent Sessions with Logins"),'toptab'=>'admhome'));

$res_logins = db_query("SELECT session.user_id AS user_id,"
	. "session.ip_addr AS ip_addr,"
	. "session.time AS time,"
	. "user.user_name AS user_name FROM session,user "
	. "WHERE session.user_id=user.user_id AND "
	. "session.user_id>0 AND session.time>0 ORDER BY session.time DESC LIMIT 50");

if (db_numrows($res_logins) < 1) {
	$feedback = "No records found, There must be an error somewhere.";

} else {

	print '<h3>'._("Most Recent Sessions with Logins").'</h3>';
	print "\n<p>";

	$title_arr=array();
	$title_arr[]=_("User Name");
	$title_arr[]=_("Ip");
	$title_arr[]=_("Date");
	print html_build_list_table_top ($title_arr);

	while ($row_logins = db_fetch_array($res_logins)) {
		print '<tr class="'.utils_get_alt_row_color($inc++).'">';
		print "<td>$row_logins[user_name]</td>";
		print "<td>$row_logins[ip_addr]</td>";
		print "<td>" . format_date($sys_datefmt,$row_logins['time']) . "</td>";
		print '</tr>';
	}

	print '</table>';
}
$HTML->footer(array());

?>
