<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: show.php,v 1.22 2005/04/11 13:15:51 toddy Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2005 (c) Mathieu Roy <yeupou--gnu.org>
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



function show_item_list ($result,
			 $offset,
			 $total_rows,
			 $field_arr, #4
			 $title_arr,
			 $width_arr,
			 $url,
			 $nolink=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_list ';
  global $sys_datefmt,$group_id,$PHP_SELF,$chunksz;

  /*
      Accepts a result set from the bugs table. Should include all columns from
      the table, and it should be joined to USER to get the user_name.
  */
  $rows=db_numrows($result);

  # Build the list of links to use for column headings
  # Used to trigger sort on that column
  if ($url)
    {
      $links_arr = array();
      while (list(,$field) = each($field_arr))
	{
	  $links_arr[] = $url.'&amp;order='.$field.'#results';
	}
    }

  /*
      Show extra rows for <-- Prev / Next -->
  */

  $nav_bar ='<h5 align="center">';

  # If all bugs on screen so no prev/begin pointer at all
  if ($total_rows > $chunksz)
    {
      if ($offset > 0)
	{
	  $nav_bar .=
	     '<a href="'.$url.'&amp;offset=0#results"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/first.png" border="0" alt="'._("Begin").'" />'._("Begin").'</a>'.
	     '&nbsp;&nbsp;&nbsp;&nbsp;'.
	     '<a href="'.$url.'&amp;offset='.($offset-$chunksz).
	     '#results"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/previous.png" border="0" alt="'._("Previous Results").'" />'._("Previous Results").'</a>';
	}
      else
	{
	  $nav_bar .=
	     '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/firstgrey.png" border="0" alt="'._("Begin").'" /><font class="italic">'._("Begin").'</font>'.
	     '&nbsp;&nbsp;&nbsp;&nbsp;'.
	     '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/previousgrey.png" border="0" alt="'._("Previous Results").'" /><font class="italic">'._("Previous Results").'</font>';
	}
    }


  $offset_last = min($offset+$chunksz-1, $total_rows-1);

  $nav_bar .= " &nbsp;  &nbsp; &nbsp; &nbsp; ".sprintf(_("Items %s to %s"), ($offset+1), ($offset_last+1))."  &nbsp; &nbsp; &nbsp; &nbsp; ";


  # If all items are on screen, no next/end pointer at all
  # FIXME: it should not count private items
  if ($total_rows > $chunksz)
    {
      if ( ($offset+$chunksz) < $total_rows )
	{

	  $offset_end = ($total_rows - ($total_rows % $chunksz));
	  if ($offset_end == $total_rows)
	    { $offset_end -= $chunksz; }

	  $nav_bar .=
	     '<a href="'.$url.'&amp;offset='.($offset+$chunksz).
	     '#results">'._("Next Results").'<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/next.png" border="0" alt="'._("Next Results").'" /></a>'.
	     '&nbsp;&nbsp;&nbsp;&nbsp;'.
	     '<a href="'.$url.'&amp;offset='.($offset_end).
	     '#results">'._("End").'<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/last.png" border="0" alt="'._("End").'" /></a>';
	}
      else
	{
	  $nav_bar .= '<font class="italic">'._("Next Results").'</font><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/nextgrey.png" border="0" alt="'._("Next Results").'" />'.
	     '&nbsp;&nbsp;&nbsp;&nbsp;'.
	     '<font class="italic">'._("End").'</font><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/lastgrey.png" border="0" alt="'._("End").'" />';
	}
    }
  $nav_bar .= '</h5>';

  # Print prev/next links
  print $nav_bar.'<br />';

  print html_build_list_table_top ($title_arr,$links_arr);

  #see if the bugs are too old - so we can highlight them
  $nb_of_fields = count($field_arr);



  for ($i=0; $i < $rows ; $i++)
    {
      # Do not even show private item, apart to technician level members
      # and submitter
      if (db_result($result, $i, 'privacy') == "2" &&
	  !member_check_private(0,$group_id) &&
	  db_result($result,$i,'submitted_by') != user_getname())
	{
	  dbg("Private item.");
	}
      else
	{
	  print '<tr class="'.utils_get_priority_color(db_result($result, $i, 'priority'), db_result($result, $i, 'status_id')).'">'."\n";
	  $thisitem_id = db_result($result, $i, 'bug_id');

	  for ($j=0; $j<$nb_of_fields; $j++)
	    {
	      # If we are in digest mode, add the digest checkbox
	      if ($field_arr[$j] == "digest")
		{
		  print '<td class="center">'.form_input("checkbox", "items_for_digest[]", $thisitem_id).'</td>';
		  continue;
		}

	      $value = db_result($result, $i, $field_arr[$j]);
	      if ($width_arr[$j])
		{
		  $width = 'width="'.$width_arr[$j].'%"';
		}
	      else
		{
		  $width = '';
		}

	      if (trackers_data_is_date_field($field_arr[$j]) )
		{
		  if ($value)
		    { print "<td $width>".format_date($sys_datefmt,$value).'</td>'."\n"; }
		  else
		    { print "<td align=\"middle\" $width>-</td>\n"; }

		}
	      else if ($field_arr[$j] == 'bug_id')
		{

		  if ($nolink)
		    { print "<td $width>#$value</td>\n"; }
		  else
		    {
		      print "<td $width>";

		      print '<a href="?func=detailitem&amp;item_id='.$value.'">';

		      print '&nbsp;#'.$value .'</a></td>'."\n";

		    }

		}
	      else if (trackers_data_is_username_field($field_arr[$j]))
		{

		  if ($nolink)
		    { print "<td $width>$value</td>\n"; }
		  else
		    { print "<td $width>".utils_user_link($value)."</td>\n"; }

		}
	      else if (trackers_data_is_select_box($field_arr[$j]))
		{
		  print "<td $width>". trackers_data_get_cached_field_value($field_arr[$j], $group_id, $value) .'</td>'."\n";

		}
	      else
		{
		  if ($nolink)
		    { print "<td $width>". $value .'&nbsp;</td>'."\n"; }
		  else
		    {
		      print "<td $width>".'<a href="?func=detailitem&amp;item_id='.
			$thisitem_id.'">'.
			$value .'</a>&nbsp;</td>'."\n";
		    }
		}
	    }
	}
      print "</tr>\n";
    }

  print '</table>';

  # Print prev/next links
  print "<br />".$nav_bar;

}


# Show the changes of the tracker data we have for this item,
# excluding details
function show_item_history ($item_id,$group_id, $no_limit=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_history ';
  global $sys_datefmt;
  $result=trackers_data_get_history($item_id);
  $rows=db_numrows($result);

  # If no limit is not set, print only 10 latest news items
  # yeupou--gnu.org 2004-09-17: currently we provide no way to get the
  # full history. We'll see if users request it.
  if ($no_limit)
    {
      $title = _("History");
    }
  else
    {
      if ($rows > 15)
	{ $rows = 15; }
      $title = sprintf(_("%s latest changes"), $rows);
    }


  print "\n".'<h3>'.html_anchor($title, "history").'</h3>';

  if ($rows > 0)
    {

      $title_arr=array();
      $title_arr[]=_("Date");
      $title_arr[]=_("Changed By");
      $title_arr[]=_("Updated Field");
      $title_arr[]=_("Previous Value");
      $title_arr[]="=>";
      $title_arr[]=_("Replaced By");

      print html_build_list_table_top ($title_arr);

      $j=0;
      for ($i=0; $i < $rows; $i++)
	{
          $field = db_result($result, $i, 'field_name');
	  $field_label = trackers_data_get_label($field);
          # if field_label is empty, no label was found, return as it is stored
          if (!$field_label)
            { $field_label = $field; }

	  $value_id =  db_result($result, $i, 'old_value');
	  $new_value_id =  db_result($result, $i, 'new_value');

          $date = db_result($result, $i, 'date');
          $user = db_result($result, $i, 'user_name');

          # If the previous date and user are equal, do not print user
          # and date
          if ($date == $previous_date && $user == $previous_user)
            {
     	  print "\n".'<tr class="'. utils_get_alt_row_color($j).'"><td>&nbsp;</td><td>&nbsp;</td>';

            }
          else
            {

          $j++;
	  print "\n".'<tr class="'. utils_get_alt_row_color($j).'">';

	  # Date
	  print '<td align="center" class="smaller">'.format_date($sys_datefmt,$date).'</td>';

	  # Person
	  print '<td align="center" class="smaller">'.utils_user_link($user).'</td>';
            }

          $previous_date = $date;
          $previous_user = $user;

	  # Updated Field
	  print '<td class="smaller" align="center">'.$field_label.'</td>';

	  # Previous value
	  print '<td class="smaller" align="right">';
	  if (trackers_data_is_select_box($field))
	    {
	      # Its a select box look for value in clear
              if ($value_id == "transition-other-field-update")
                {
	          print "-"._("Automatic update due to transitions settings")."-";
                }
              else
                {
                  print trackers_data_get_value($field, $group_id, $value_id);
                }
	    }
	  else if (trackers_data_is_date_field($field))
	    {
	      # For date fields do some special processing
	      print format_date($sys_datefmt,$value_id);
	    }
	  else
	    {
	      # It's a text zone then display directly
	      print $value_id;
	    }

           print '</td><td class="smaller" align="center"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/next.png" border="0" alt="=>" /></td><td class="smaller" align="left">';
	  # New value
	  if (trackers_data_is_select_box($field))
	    {
	      # It's a select box look for value in clear
	      print trackers_data_get_value($field, $group_id, $new_value_id);
	    }
	  else if (trackers_data_is_date_field($field))
	    {
	      # For date fields do some special processing
	      print format_date($sys_datefmt,$new_value_id);
	    }
	  else
	    {
	      # It's a text zone then display directly
	      print $new_value_id;
	    }
	  print '</td>';

	  print '</tr>';

	}
      print '</table>';

    }
  else
    {
      print "\n".'<font class="warn">'._("No Changes Have Been Made to This Item").'</font>';
    }
}


function show_item_details ($item_id, $group_id, $ascii=false, $item_assigned_to=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_details ($item_id, $group_id, $ascii=false)';
  print format_item_details($item_id,$group_id,$ascii,$item_assigned_to);
}



function show_item_attached_files ($item_id,$group_id, $ascii=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_attached_files ($item_id,$group_id, $ascii=false)';
  print format_item_attached_files ($item_id,$group_id, $ascii);
}


function show_item_cc_list ($item_id,$group_id, $ascii=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_cc_list ($item_id,$group_id, $ascii=false)';
  print format_item_cc_list ($item_id,$group_id, $ascii);
}


# Look for items that $item_id depends on in all artifact
function show_item_dependency ($item_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_item_dependency ($item_id)';
  return show_dependent_item($item_id, $dependson=1);
}


# Look for items that depends on $item_id in all artifacts (default)
# or look for items that $item_id depends on in all artifact.
function show_dependent_item ($item_id, $dependson=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_dependent_item ($item_id, $dependson=0)';
  global $group_id;

  $artifacts = array("support", "bugs", "task", "patch");
  $result = array();
  $rows = array();
  $is_manager = member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'1');

  if (!$dependson)
    { $title = _("Items that depend on this one"); }
  else
    { $title = _("Depends on the following items"); }

  # Slurps the database.
  while (list($num, $art) = each($artifacts))
    {
      if (!$dependson)
	{
	  $sql = "SELECT ".$art.".bug_id,".$art.".summary,".$art.".status_id,".$art.".resolution_id,".$art.".group_id,".$art.".priority,".$art.".privacy,".$art.".submitted_by ".
	     " FROM ".$art.",".$art."_dependencies ".
	     " WHERE ".$art.".bug_id=".$art."_dependencies.item_id ".
	     " AND ".$art."_dependencies.is_dependent_on_item_id='$item_id'".
	     " AND ".$art."_dependencies.is_dependent_on_item_id_artifact='".ARTIFACT."' ORDER by ".$art.".bug_id";
	}
      else
	{
	  $sql = "SELECT ".$art.".bug_id,".$art.".summary,".$art.".status_id,".$art.".resolution_id,".$art.".group_id,".$art.".priority,".$art.".privacy,".$art.".submitted_by".
	     " FROM ".$art.",".ARTIFACT."_dependencies ".
	     " WHERE ".$art.".bug_id=".ARTIFACT."_dependencies.is_dependent_on_item_id ".
	     " AND ".ARTIFACT."_dependencies.item_id='$item_id'".
	     " AND ".ARTIFACT."_dependencies.is_dependent_on_item_id_artifact='".$art."' ORDER by ".$art.".bug_id ";

	}

      $result[$art] = db_query($sql);
      $rows[$art] = db_numrows($result[$art]);
    }

  # Give back the HTML output, if we have some data.
  if ($rows["support"] > 0 ||
      $rows["bugs"] > 0 ||
      $rows["task"] > 0 ||
      $rows["patch"] > 0)
    {

      global $HTML;
      print $HTML->box_top($title,'',1);

      reset($artifacts);
      while (list($num, $art) = each($artifacts))
	{
	  for ($i=0; $i < $rows[$art]; $i++)
	    {

	      $link_to_item = $GLOBALS['sys_home'].$art.'/?func=detailitem&amp;item_id='. db_result($result[$art], $i, 'bug_id');

	      $dstatus = db_result(db_query("SELECT value FROM ".$art."_field_value WHERE bug_field_id='108' AND (group_id='".db_result($result[$art], $i, 'group_id')."' OR group_id='100') AND value_id='".db_result($result[$art], $i, 'resolution_id')."' ORDER BY bug_fv_id DESC LIMIT 1"), 0, 'value');


	      print '
  <li class="'.get_priority_color(db_result($result[$art], $i, 'priority'), db_result($result[$art], $i, 'status_id')).'">';

	      # Ability to remove a dependency is only given to technician
	      # level members of a project.
	      if ($dependson && $is_manager)
		{
		  print '<span class="trash"><a href="'.$PHP_SELF.'?func=delete_dependancy&amp;item_id='.$item_id.'&amp;item_depends_on='.db_result($result[$art], $i, 'bug_id').
		    '&amp;item_depends_on_artifact='.$art.'">'.
		    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" alt="'._("Delete this dependancy?").'" class="icon" /></a></span>';
		}

              # Link to the item
	      print '
   	<a href="'.$link_to_item.'">';

	      # Show the item type with an icon
	      print '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.utils_get_tracker_icon($art).'.png" class="icon" alt="'.$art.'" />';

	      print utils_get_tracker_prefix($art).' #'.db_result($result[$art], $i, 'bug_id');

	      print '</a> : <a href="'.$link_to_item.'">';

              # Print summary only if the item is not private
	      if (db_result($result, $i, 'privacy') == "2" &&
		  !member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2') &&
		  db_result($result[$art],$i,'submitted_by') != user_getid())
		{ print _("---- Private ----");	}
	      else
		{ print db_result($result[$art], $i, 'summary'); }
	      print '</a>';

	      if (db_result($result[$art], $i, 'group_id') != $group_id)
		{
		  print ', '.group_getname(db_result($result[$art], $i, 'group_id'));
		}

              # Mention the status
	      print '&nbsp;<font class="smaller">['.$dstatus.']</font>';

	      print '</li>';
	    }
	}
      print $HTML->box_bottom(1);

     # Link to digest dependant items
      if ($dependson)
	{
	  reset($artifacts);
	  while (list(,$art) = each($artifacts))
	    {
	      if ($rows[$art] > 0)
		{
                  switch ($art)
                    {
                      case "support":
                        $linktitle = _("Digest support dependencies");
                        break;
                      case "bugs":
                        $linktitle = _("Digest bug dependencies");
                        break;
                      case "task":
                        $linktitle = _("Digest task dependencies");
                        break;
                      case "patch":
                        $linktitle = _("Digest patch dependencies");
                        break;
                      # add an emergency fallback
                      default:
                        $linktitle = sprintf(_("Digest %s dependencies"), $art);
                    }
		  print utils_link($GLOBALS['sys_home'].$art.'/?group_id='.$group_id.'&amp;func=digestselectfield&amp;dependencies_of_item='.$item_id.'&amp;dependencies_of_tracker='.ARTIFACT, "[$linktitle]").' ';
		}
	    }
	}

    }
  else
    {
      print '<br /><font class="warn">';
      if (!$dependson)
	{ print _("No items are dependent on this one"); }
      else
	{ print _("This item doesn't depend on any other items"); }
      print '</font>';
      print db_error();
    }
}


?>