<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sendmail.php,v 1.19 2005/06/20 15:00:59 yeupou Exp $
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Every mails sent should be using functions listed here.

# The function that finally send the mail.
# Every mail sent by Savannah should be using that function which
# works like mail().
# Note: $to can be a coma-separated list.
#       $from and $to can contain user names
function sendmail_mail ($from, 
			$to, 
			$subject, 
			$message,  #4
			$savannah_project=0, 
			$savannah_artifact=0, 
			$savannah_artifact_id=0, 
			$reply_to=0, # 8
			$additional_headers=0,
			$exclude_list=0) 
{

  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':sendmail_mail  ';

  # Make sure that users cannot insert malicious content
  # (apart in message, which is not part of the headers)
  $to = stripslashes($to);
  $from = stripslashes($from);
  $subject = stripslashes($subject);

  # Make sure the message respect the 78chars max width
  # Make also sure we havent got excessive slashes escaping
  $message = wordwrap($message, 78);

  # Convert ; into
  $to = ereg_replace(";", ",", $to);
  # Transform $to in an ordered list, without duplicates
  # (remove blankspaces)
  $to = array_unique(explode(",", ereg_replace(" ", "", $to)));

  # If $from is a login name, write nice From: field
  $fromuid = user_getid($from);
  if (user_exists($fromuid))
    {
      $from = user_getrealname($fromuid, 1)." <".user_getemail($fromuid).">";
    }

  # Write the add. headers 
  # Note: RFC-821 recommends to use \r\n as line break in headers but \n
  # works and there are report of failures with \r\n so we let \n for now.
  $more_headers = "From: ".$from."\n";
  if ($reply_to)
    { $more_headers .= "Reply-To: ".$reply_to."\n"; }
  $more_headers .= "X-Savane-Server: ".$GLOBALS['SERVER_NAME'].":".$GLOBALS['SERVER_PORT']." [".$GLOBALS['SERVER_ADDR']."]\n";

  # Necessary for proper utf-8 support
  $more_headers .= "MIME-Version: 1.0\n";
  $more_headers .= "Content-Type: text/plain;charset=UTF-8\n";

  # Savane details
  if ($savannah_project) 
    { $more_headers .= "X-Savane-Project: ".$savannah_project."\n"; }
  if ($savannah_artifact) 
    { $more_headers .= "X-Savane-Tracker: ".$savannah_artifact."\n"; }  
  if ($savannah_artifact_id) 
    { $more_headers .= "X-Savane-Item-ID: ".$savannah_artifact_id."\n"; }
  if ($additional_headers) 
    { $more_headers .= $additional_headers."\n";  }

  # User details
  $more_headers .= "User-Agent: ".$GLOBALS['HTTP_USER_AGENT']."\n";
  $more_headers .= "X-Apparently-From: ".$GLOBALS['REMOTE_ADDR']."\n";

  # Message ID
  $msg_id = sendmail_create_msgid();
  $more_headers .= "Message-Id: <".$msg_id.">\n";
  # Add refs
  if ($savannah_artifact && $savannah_artifact_id)
    {      
      $more_headers .= "References: ".trackers_get_msgid($savannah_artifact, $savannah_artifact_id)."\n";
      $more_headers .= "In-Reply-To: ".trackers_get_msgid($savannah_artifact, $savannah_artifact_id, true)."\n";
    }

  # Add a signature for the server
  $message .= "\n\n_______________________________________________
  ".sprintf(_("Message sent via/by %s"), $GLOBALS['sys_name'])."
  http://".$GLOBALS['sys_default_domain'].$GLOBALS['sys_home']."\n";

  # Register the message id for future references
  if ($savannah_artifact && $savannah_artifact_id)
    {
      trackers_register_msgid($msg_id, $savannah_artifact, $savannah_artifact_id);
    }

  # If there's an exclude list, create an array 
  # Convert ; into
  $exclude = array();
  if ($exclude_list)
    {
      $exclude_list = ereg_replace(";", ",", $exclude_list);
       $exclude = array_unique(explode(",", ereg_replace(" ", "", $exclude_list)));
    }

  while (list(,$v) = each($exclude)) 
    {
       if ($v)
         { $exclude[$v] = 1;  }
    }


  # Forge the real to list, by parsing every item of the $to list
  unset($real_to);
  $list = array();
  $user_subject = array();
  $user_name  = array();

  while (list($k,$v) = each($to)) 
    {
      # Exists in the exclude array? Skip it
      if ($exclude[$v])
        { continue; }

      $i++;
      unset($skip);
      # If an address is a username, get the email address from
      # the database.
      # If nothing is found, just let the username - there's maybe a 
      # local alias.
      if (!ereg("@", $v)) 
	{
	  if (user_exists($v)) 
            { 
                # Exists in the exclude array? Skip it
  	       if (is_array($exclude) && array_key_exists(user_getname($v), $exclude))
                  { continue; }

                # Does the user have a specific subject line?
                if (user_get_preference("subject_line", $v) != "")
                  {
                     $list[$i] = $v;
                     $user_subject[$v] = sendmail_format_subject_line(user_get_preference("subject_line", $v), $savannah_project, $savannah_artifact, $savannah_artifact_id)." ".$subject;
                     $user_name[$v] = user_getrealname($v, 1)." <".user_getemail($v).">";
                     $skip = 1;
                  }

                $v = user_getrealname($v, 1)." <".user_getemail($v).">"; 
            }
        }
    # If $v is set, add it to the list, 
    # unless user want a specific subject line
    if (!$skip)
      { $real_to .= $v.", "; }

    } 

  # Add eventually info on the subject
  if ($savannah_artifact && $savannah_artifact_id) 
    { 
       $subject = "[".utils_get_tracker_prefix($savannah_artifact)." #".$savannah_artifact_id."] ".$subject; 
    }
 
   # Remove the extra ", " at the end of the list
   $real_to = substr($real_to,0,-2);

   # Beuc - 20050316
   # That's what I intended to do:

   # All newlines should be \r\n; this is apparently more
   # RFC821-compliant.
   # $message = preg_replace("/(?<!\r)\n/", "\r\n", $message);

   # However the opposite is certainly more Mailman-compliant; a bug
   # report has been posted to the Mailman team - wait&see [bug #1980]
   $message = str_replace("\r\n", "\n", $message);

   # Send the mail in UTF-8
   # Fixme: apparently From/To should not contains anything but ascii...
   #        utf-8 stuff in names will look like garbage.
   if ($real_to) 
	{
	  $ret .= mail($real_to, sendmail_encode_header_content($subject), $message, $more_headers);
	  fb(sprintf(_("Mail sent to %s"), utils_antispam_email($real_to)));
	} 
   
   # Send mails with specific subject line
   while (list(,$v) = each($list)) 
     {
        $ret .= mail($user_name[$v], sendmail_encode_header_content($user_subject[$v]), $message, $more_headers);
	fb(sprintf(_("Mail sent to %s"), utils_antispam_email($user_name[$v])));
     }  
      
  return $ret; 
}


# Needed to send utf-8 headers:
function sendmail_encode_header_content ($header, $charset="UTF-8")
{
  # Take a look at http://www.faqs.org/rfcs/rfc2047.html
  # We should use mb_encode_mimeheader() but it just does not work.
  return "=?UTF-8?B?".base64_encode($header)."?=";
}


# A form for logged in users to send mails to others users
function sendmail_form_message ($form_action, $user_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':sendmail_form_message ($form_action, $user_id) ';  global $HTML;
  $HTML->box1_top(sprintf(_("Send a Message to %s"),user_getrealname($user_id)));
  print '<p class="warn">'.("If you are writing for help, did you read the project 
documentation first? Try to provide any potentially useful information you can think of.").'</p>';

  # We do not really bother finding out the realname + email, sendmail_mail()
  # will do it.
  print '
 <form action="'.$form_action.'" method="post">
   <input type="hidden" name="touser" value="'.$user_id.'">
   <input type="hidden" name="fromuser" value="'.user_getname().'">

   <p><font class="preinput">'._("From:").'</font> '.user_getrealname(user_getid(), 1).' &lt;'.user_getemail(user_getid()).'&gt;<br />
    <font class="preinput">'._("Mailer:").'</font> '.$GLOBALS['HTTP_USER_AGENT'].' - '.$GLOBALS['REMOTE_ADDR'].'</p>
   <p><font class="preinput">'._("Subject:").'</font><br />
   &nbsp;&nbsp;&nbsp;<input type="text" name="subject" size="60" maxlength="45" value=""></p>
   <p><font class="preinput">'._("Message:").'</font><br />
   &nbsp;&nbsp;&nbsp;<textarea name="body" rows="20" cols="60"></textarea></p>

   <p align="center"><input type="submit" name="send_mail" value="Send Message"></p>
</form>';
  $HTML->box1_bottom();
}

function sendmail_format_subject_line ($subject_line, $savannah_project="", $savannah_artifact="", $savannah_artifact_id="") 
{

  $subject_line = ereg_replace("%SERVER", $GLOBALS['sys_default_domain'], $subject_line);
  $subject_line = ereg_replace("%PROJECT", $savannah_project, $subject_line);
  $subject_line = ereg_replace("%TRACKER", $savannah_artifact, $subject_line);
  return ereg_replace("%ITEM", "#".$savannah_artifact_id, $subject_line);
}

function sendmail_create_msgid ()
{
  mt_srand((double)microtime()*1000000);
  return date("Ymd-His", time()).".sv".user_getid().".".mt_rand(0,100000)."@".$_SERVER["HTTP_HOST"];
}

?>