<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: form.php,v 1.2 2004/11/22 08:25:48 yeupou Exp $
#
#  Copyright 2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# To use this form that disallow duplicates:
#    - form_header must be used on the form
#    - form_check must be used before any insert in the db after submission
#    - form_clean must be used after succesful item submission
#

# Start the form with unique ID, store it in the database
function form_header ($action, $form_id=false, $method="post", $extra=false)
{
  if ($extra)
    { $extra = " $extra"; };
    
  # Keep previous form id, in case of form that are recreated on failure
  if (!$form_id)
    { 
      mt_srand((double)microtime()*1000000);
      $form_id=md5(mt_rand(0,1000000));
    }
  $result = db_query("INSERT INTO form (form_id,timestamp,user_id) VALUES ('$form_id','".time()."','".user_getid()."')");
  if (db_affected_rows($result) != 1)
    { fb(_("System error while creating the form, report it to admins"), 1); }
  
  return '
  <form action="'.$action.'" method="'.$method.'"'.$extra.'>'.form_input("hidden","form_id",$form_id);

}

# Usual input
function form_input ($type, $name, $value="")
{
  if ($value != "")
    { $value = 'value="'.$value.'"'; }
  return '
    <input type="'.$type.'" name="'.$name.'" '.$value.' />';

}

# Add submit button
function form_submit($text=false, $submit_name="update")
{
  if (!$text)
    { $text = _("Submit"); }
  
  return form_input("submit", $submit_name, $text);


}

# Close the form, with submit button
function form_footer ($text=false, $submit_name="update")
{
  return '
    <p class="center">'.form_submit($text, $submit_name).'
    </p>
  </form>';

}

# Check whether this is a duplicate or not: return true if the form
# is ok.
# Exit if we found sql wildcards: forged form, probably.
# We do need this extra check for anynomous users. Logged in users can forge
# their id and remove all the form id of their user, if they wish. Its their
# problem.
function form_check ($form_id)
{
  if (user_getid() == 0 &&
      (strspn($form_id, "abcdefghijklmnopqrstuvwxyz0123456789") != strlen($form_id)))
    {
      fb(_("Unrecognized unique form_id"), 1);
      return 0;
    }

  if (db_numrows(db_query("SELECT form_id FROM form WHERE user_id='".user_getid()."' AND form_id='".addslashes($form_id)."'")) < 1)
    {
      fb(_("Duplicate Post: this form was already submitted."),1);
      return 0;
    }

  return 1;
}

# Remove form_id from database: the item was posted
function form_clean ($form_id)
{
  $success = db_affected_rows(db_query("DELETE FROM form WHERE user_id='".user_getid()."' AND form_id='".addslashes($form_id)."'"));
  if (!$success)
    { fb(_("Error during unique form_id removal"), 1); }
  
  return $success;
}




?>