<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: change_notifications.php,v 1.7 2005/04/06 20:23:11 toddy Exp $
#
#  Copyright 2001-2002 (c)  Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "../include/pre.php";
require "../include/account.php";
require_directory("trackers");


/*  ==================================================
    Set up some data structure needed throughout the script
 ================================================== */

$user_id = user_getid();
# get notification roles
# get notification roles
$res_roles = trackers_data_get_notification_roles();
$num_roles = db_numrows($res_roles);
$i=0;
while ($arr = db_fetch_array($res_roles))
{
  $arr_roles[$i] = $arr; $i++;
}

# get notification events
$res_events = trackers_data_get_notification_events();
$num_events = db_numrows($res_events);
$i=0;
while ($arr = db_fetch_array($res_events))
{
  $arr_events[$i] = $arr; $i++;
}

# build the default notif settings in case the user has not yet defined her own
# By default it's all 'yes'
for ($i=0; $i<$num_roles; $i++)
{
  $role_id = $arr_roles[$i]['role_id'];
  for ($j=0; $j<$num_events; $j++)
    {
      $event_id = $arr_events[$j]['event_id'];
      $arr_notif[$role_id][$event_id] = 1;
    }
}

# Overwrite with user settings if any
$res_notif = trackers_data_get_notification($user_id);
while ($arr = db_fetch_array($res_notif))
{
  $arr_notif[$arr['role_id']][$arr['event_id']] = $arr['notify'];
}

/*  ==================================================
    The form has been submitted - update the database
 ================================================== */

if ($submit)
{
  ######### Event/Role specific settings
  for ($i=0; $i<$num_roles; $i++)
    {
      $role_id = $arr_roles[$i]['role_id'];
      for ($j=0; $j<$num_events; $j++)
	{
	  $event_id = $arr_events[$j]['event_id'];
	  $cbox_name = 'cb-'.$role_id.'-'.$event_id;
	  #print "DBG $cbox_name -> '".$$cbox_name."'<br />";
	  $arr_notif[$role_id][$event_id] = ( $$cbox_name ? 1 : 0);
	}
    }
  trackers_data_delete_notification($user_id);
  $res_notif = trackers_data_insert_notification($user_id, $arr_roles, $arr_events, $arr_notif);

  # Give Feedback
  if ($res_notif)
    { fb(_("Successfully updated notification by role settings")); }
  else
    { fb(_("Failed to update notification by role settings"), 1); }

  ######### Reminder
  if (user_set_preference("batch_frequency", addslashes($form_frequency)))
    { fb(_("Successfully Updated Reminder Settings")); }
  else
    { fb(_("Failed to Update Reminder Setting"), 1); }

  if (user_get_preference("batch_lastsent") == "")
    {
      if (user_set_preference("batch_lastsent", "0"))
	{ fb(_("Successfully set Timestamp of the Latest Reminder")); }
      else
	{ fb(_("Failed to Reset Timestamp of the Latest Reminder"), 1); }
    }

  ####### Subject line
  # First test content: to avoid people entering white space and being in
  # trouble at a later point, first check if we can find something else than
  # white space
  if (preg_replace("/ /", "", $form_subject_line))
    {
      # Some characters cannot be allowed
      if (strspn($form_subject_line,"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_[]()&=$*:!,;?./%$ <>|") == strlen($form_subject_line))
	{
	  user_set_preference("subject_line", $form_subject_line);
	  fb(_("Successfully configured subject line"));
	}
      else
	{ fb(_("Non alphanumeric characters in the proposed subject line, subject line configuration skipped."), 1); }
    }
  else
    {
      # Empty? Check if there is a configuration already. If so, kill it.
      if (user_get_preference("subject_line"))
	{
	  user_unset_preference("subject_line");
	}

    }



}
# end submit


/*  ==================================================
    Start HTML
 ================================================== */

site_user_header(array('title'=>_("Mail Notification Settings"),'toptab'=>'account'));

print '<h3>'._("Role related notification settings").'</h3>';
print '<p>'._("You can tune your notification settings and decide what item changes you want to be aware of, depending on your role.").'</p>
';


print '
<form action="'.$PHP_SELF.'" method="post">';

# Build Role/Event table
# Rk: Can't use html_build_list_table_top because of the specific layout


print '
<table class="box">
<tr>
    <td colspan="'.$num_roles.'" align="center" width="50%" class="boxtitle">'._("If my role in an item is:").'</td>
    <td rowspan="2" width="50%" class="boxtitle">'._("I want to be notified when:").'</td>
</tr>';

for ($i=0; $i<$num_roles; $i++)
{
  print '<td align="center" width="10%" class="boxtitle"><font class="smaller">'.$arr_roles[$i]['short_description']."</font></td>\n";
}
print "</tr>\n";

for ($j=0; $j<$num_events; $j++)
{
  $event_id = $arr_events[$j]['event_id'];
  $event_label = $arr_events[$j]['event_label'];
  print '<tr class="'.utils_get_alt_row_color($j)."\">\n";
  for ($i=0; $i<$num_roles; $i++)
    {
      $role_id = $arr_roles[$i]['role_id'];
      $role_label = $arr_roles[$i]['role_label'];
      $cbox_name = 'cb-'.$role_id.'-'.$event_id;
      if ((($event_label == 'NEW_ITEM') && ($role_label != 'ASSIGNEE') && ($role_label != 'SUBMITTER')) )
	{
	  # if the user is not an assignee or a submitter the new_item event is meaningless
	  print '   <td align="center"><input type="hidden" name="'.$cbox_name.'" value="1" />-</td>'."\n";
	}
      else
	{
	  print '   <td align="center"><input type="checkbox" name="'.$cbox_name.'" value="1" '.
	    ($arr_notif[$role_id][$event_id] ? 'checked="checked"':'')." /></td>\n";
	}
    }
  print '   <td>'.$arr_events[$j]['description']."</td>\n";
  print "</tr>\n";
}

print'
</table>
';

print '<br /><h3>'._("Reminder").'</h3>';
print '<p>'._("You can also receive reminders about opened items assigned to you, when their priority is higher than 5. Note that projects administrators can also set reminders for you, out of your control, for your activities on the project they administrate.").'</p>
';
$frequency = array("0" => _("None"),
		   "1" => _("Daily"),
		   "2" => _("Weekly"),
		   "3" => _("Monthly"));

print '<span class="preinput">'._("Frequency of reminders:").'</span> &nbsp;&nbsp;';
print html_build_select_box_from_array($frequency,
				       "form_frequency",
				       user_get_preference("batch_frequency"));


print '<br /><h3>'._("Subject Line Configuration").'</h3>';
print '<p>'.sprintf(_("Every mail sent by Savane got mail headers you can use to filter messages: you will always find the header %s and, when it makes sense, you will also find %s, %s, and %s."), "X-Savane-Server", "X-Savane-Project", "X-Savane-Tracker", "X-Savane-Item-ID").'</p><p>'.sprintf(_("Another option, for message filtering, is to configure the prefix of the subject line, with the following form. In this form, you can use the strings %s, %s, %s, and %s. They will be replaced by the appropriate values. If you let this form empty, you will get the default subject line."), "%SERVER", "%PROJECT", "%TRACKER", "%ITEM").'
</p>
';

$frequency = array("0" => _("None"),
		   "1" => _("Daily"),
		   "2" => _("Weekly"),
		   "3" => _("Monthly"));

print '<span class="preinput">'._("Subject Line:").'</span> &nbsp;&nbsp;';
print '<input name="form_subject_line" size="50" type="text" value="'.user_get_preference("subject_line").'" />';


print '
<p align="center"><input type="submit" name="submit" value="'._("Update").'" /></p>
</form>';

site_user_footer(array());

?>
