<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: change.php,v 1.12 2005/03/20 13:10:16 yeupou Exp $
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                          Yves Perrin <yves.perrin--at--cern.ch>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";

# Check if the user is logged in.
session_require(array('isloggedin'=>'1'));

if (!$item)
{
  exit_missing_param();
}

########################################################################
# Update the database
if ($update)
{
  # Update the database and redirect to account conf page
  if ($item == "realname")
    {
      ################# Realname

      if (!$newvalue)
	{ fb(_("You must supply a new real name."), 1); }
      else
	{
	  $newvalue = strtr($newvalue, "\'\"\,", "     ");
	  $success = db_query("UPDATE user SET realname='".addslashes($newvalue)."' WHERE user_id=".user_getid());
	  if ($success)
	    { fb(_("Real Name updated.")); }
	  else
	    { fb(_("Failed to update the database."), 1); }
	}

    }
  else if ($item == "timezone")
    {
      ################# Timezone

      $success = db_query("UPDATE user SET timezone='$newvalue' WHERE user_id=" . user_getid());
      if ($success)
	{ fb(_("Timezone updated.")); }
      else
	{ fb(_("Failed to update the database."), 1); }
    }
  else if ($item == "password")
    {
      ################# password

      require  "../include/account.php";

      $success = 1;

      # check against old pw
      db_query("SELECT user_pw, status FROM user WHERE user_id=" . user_getid());
      $row_pw = db_fetch_array();

      # CERN_SPECIFIC: sys_use_pamauth have to be included in the
      # configuration file and sv_update_conf
      if ($GLOBALS['sys_use_pamauth']=='yes' && $row_pw[user_pw] == 'PAM')
	{
	  # use pam authentication
	  $pam_error="";
	  if (!pam_auth(user_getname(), $oldvalue, &$pam_error))
	    {
	      ' '._("Old password is incorrect.").' '
		 . $pam_error;
	      $success = 0;
	    }

	}
      else if ($row_pw[user_pw] != md5($oldvalue))
	{
	  # use basic authentication via user table
	  fb(_("Old password is incorrect."), 1);
	  $success = 0;
	}

      if($usepam)
	{
	  # allow user to set authentication to be PAM based
	  db_query("UPDATE user SET user_pw='PAM' WHERE user_id=".user_getid());
	}
      else
	{
	  # do standard password sanity checks and update table
	  if (!$newvalue)
	    {
	      fb(_("You must supply a password."), 1);
	      $success = 0;
	    }
	  if ($newvalue != $newvaluecheck)
	    {
	      fb(_("New Passwords do not match."), 1);
	      $success = 0;
	    }
	  if (!account_pwvalid($newvalue))
	    {
	      $success = 0;
	    }

	  # Update only if everything was ok before
	  if ($success)
	    {
	      $success = db_query("UPDATE user SET user_pw='" . md5($newvalue) . "'  WHERE "
				  . "user_id=" . user_getid());
	      if ($success)
		{ fb(_("Password updated.")); }
	      else
		{ fb(_("Failed to update the database."), 1); }
	    }

	}
    }
  else if ($item == "gpgkey")
    {
      ################# GPG Key

      $success = db_query("UPDATE user SET gpg_key='$newvalue' WHERE user_id=".user_getid());
      if ($success)
	{ fb(_("GPG Key updated.")); }
      else
	{ fb(_("Failed to update the database."), 1); }
    }
  else if ($item == "email")
    {
      ################# Email

      # First step
      if (!$step)
	{
	  $confirm_hash = substr(md5($session_hash . time()),0,16);
	  $res_user = db_query("SELECT * FROM user WHERE user_id=".user_getid());
	  if (db_numrows($res_user) < 1)
	    { exit_error("Invalid User","That user does not exist."); }

	  $row_user = db_fetch_array($res_user);

	  $success = db_query("UPDATE user SET confirm_hash='$confirm_hash',email_new='$newvalue' "
			      . "WHERE user_id='".addslashes($row_user[user_id])."'");


	  if (!$success)
	    {
	      fb(_("Failed to update the database."), 1);
	    }
	  else
	    {
	      fb(_("Database updated."));

	      if ($GLOBALS['sys_https_host'])
		{ $url = 'https://'.$GLOBALS['sys_https_host'].$GLOBALS['sys_home'].'account/change.php?item=email&update=1&confirm_hash='.$confirm_hash; }
	      else
		{ $url = 'http://'.$GLOBALS['sys_default_domain'].$GLOBALS['sys_home'].'account/change.php?item=email&update=1&confirm_hash='.$confirm_hash; }

	      $message = sprintf(_("You have requested a change of email address on %s.\nPlease visit the following URL to complete the email change:"), $GLOBALS['sys_name']) . "\n\n"
		 . $url."&step=confirm\n\n"
		 . sprintf(_("-- the %s team."), $GLOBALS['sys_name']) . "\n";

	      $warning_message = sprintf(_("Someone, presumably you, has requested a change of email address on %s.\nIf it wasn't you, maybe someone is trying to steal your account...\n\nYour current address is %s, the supposedly new address is %s.\n\n"), $GLOBALS['sys_name'], $row_user[email], $newvalue)
		 . _("If you did not request that change, please visit the following URL to discard\nthe email change and report the problem to us:")."\n\n"
		 . $url."&step=discard\n\n"
		 . sprintf(_("-- the %s team."), $GLOBALS['sys_name']) . "\n";

	      $success = sendmail_mail($GLOBALS['sys_replyto']."@".$GLOBALS['sys_lists_domain'],
				       $newvalue,
				       $GLOBALS['sys_name'] .' '._("Verification"),
				       $message);

	      # yeupou@gnu.org 2003-11-09:
	      # Send also a warning to the current mail address, just in case:
	      # You can call that paranoia but
	      #  - someone can find a session open on a computer
	      #  - ask for change the mail address
	      #  - after the change, use the lost password process
	      #  ... and so change the password without knowing and
	      #  without having the user noticing that something bad is going
	      # on.
	      # The next step is probably to print the mail change request
	      # on account/ with the possibility to discard
	      sendmail_mail($GLOBALS['sys_replyto']."@".$GLOBALS['sys_lists_domain'],
			    $row_user[email],
			    $GLOBALS['sys_name'] .' '._("Verification"),
			    $warning_message);


	      if ($success)
		{
		  sprintf(_("Confirmation mailed to %s."), $newvalue);
		  fb(_("Follow the instructions in the email to complete the email change."));
		}
	      else
		{
		  fb(_("The system reported a failure when trying to send the confirmation mail. Please retry and report that problem to administrators."), 1);
		}
	    }
	}
      else if ($step == "confirm")
	{
	  $success = 1;
	  $res_user = db_query("SELECT * FROM user WHERE confirm_hash='$confirm_hash'");
	  if (db_numrows($res_user) > 1)
	    {
	      $ffeedback = (" This confirm hash exists more than once.");
	      $success = 0;
	    }
	  if (db_numrows($res_user) < 1)
	    {
	      $ffeedback = (" Invalid confirmation hash.");
	      $success = 0;
	    }
	  if ($success)
	    {
	      $row_user = db_fetch_array($res_user);
	      $success = db_query("UPDATE user SET "
				  . "email='" . $row_user['email_new'] . "',"
				  . "confirm_hash='none',"
				  . "email_new='" . $row_user['email'] . "' WHERE "
				  . "confirm_hash='$confirm_hash'");

	      if ($success)
		{ fb(_("Email address updated.")); }
	      else
		{ fb(_("Failed to update the database."), 1); }

	    }
	}
      else if ($step == "discard")
	{
	  # Just remove stuff added
	   $success = db_query("UPDATE user SET "
			       . "confirm_hash='none',"
			       . "email_new='' WHERE "
			       . "confirm_hash='$confirm_hash'");
	   if ($success)
	     { fb(_("Address change process discarded.")); }
	   else
	     { fb(_("Failed to discard the address change process, please contact administrators."), 1); }
	}
      else
	{
	  $ffeedback = ' '._("Unable to understand what to do, parameters are probably missing.");
	}
    }


  # Success is set, it means that we can safely go back to the main
  # configuration page.
  if ($success)
    {
      session_redirect($GLOBALS['sys_home']."account/?feedback=".rawurlencode($feedback));
    }

}

########################################################################
# If we reach this point, it means that not sucessful update has been
# already made.

# Defines the page depending on the item given
if ($item == "realname")
{
  ################# Realname

  $title = _("Change Real Name");
  $input_title = _("New Real Name:");
}
else if ($item == "timezone")
{
  ################# Timezone

  require "../include/timezones.php";
  $title = _("Change Timezone");
  $input_title = _("No matter where you live, you can see all dates and times as if it were in your neighborhood:");
  $input_specific = html_build_select_box_from_arrays ($TZs,$TZs,'newvalue',user_get_timezone());
}
else if ($item == "password")
{
  ################# Password

  $title = _("Change Password");

  $input_title = _("Current Password:");
  $input2_title = _("New Password:");
  $input3_title = _("Re-type New Password:");

  $form_item_name = "oldvalue";
  $form_item2_name = "newvalue";
  $form_item3_name = "newvaluecheck";

  $input_type = "password";
  $input2_type = "password";
  $input3_type = "password";

  # AFS CERN Stuff
  if ($sys_use_pamauth == "yes") {
    $input4_title = "<br />Instead of providing a new Savannah password you
      may choose to authenticate via an <b>AFS</b> account you own
      at this site (this requires your Savannah login name to be the
      same as the AFS account name). Check the following box:";

    db_query("SELECT user_pw FROM user WHERE user_id=" . user_getid());
    $row_pw = db_fetch_array();
    $uses_pam_auth = 0;
    if ($row_pw[user_pw] == 'PAM')
      {	$input4_type = 'checkbox" CHECKED'; }
    else
      { $input4_type = 'checkbox"'; }

    $form_item4_name = "usepam";
  }

}
else if ($item == "gpgkey")
{
  ################# GPG Key

  $res_user = db_query("SELECT gpg_key FROM user WHERE user_id=" . user_getid());
  $row_user = db_fetch_array($res_user);


  $title = _("Change GPG Key");
  $input_title = _("You can write down here your (ASCII) public key (gpg --export --armor keyid):");
  $input_specific = '<textarea cols="70" rows="10" wrap="virtual" name="newvalue">'.$row_user['gpg_key'].'</textarea>';

}
else if ($item == "email")
{
  ################# Email

  # First step
  if (!$step)
    {
      $title = _("Change Email Address");
      $input_title = '<p>'._("Changing your email address will require confirmation from your new email address, so that we can ensure we have a good email address on file.").'</p><p>'._("We need to maintain an accurate email address for each user due to the level of access we grant via this account. If we need to reach a user for issues related to this server, it is important that we be able to do so.").'</p><p>'._("Submitting the form below will mail a confirmation URL to the new email address. Visiting this link will complete the email change.").'</p><br />'._('New Email Address:');
    }

}


# Defines some information if not specific
if (!$form_item_name)
{ $form_item_name = "newvalue"; }
if (!$input_title)
{ $input_title = $title; }
if (!$input_type)
{ $input_type = "text"; }


########################################################################
# Actually prints the HTML page
site_user_header(array('title'=>$title,
		       'toptab'=>'account'));

print '<form action="'.$PHPSELF.'" method="post">';
print '<font class="preinput">'.$input_title.'</font>';

# Print the usual input unless we have something specific
if (!$input_specific)
{
  print '<br />&nbsp;&nbsp;&nbsp;<input name="'.$form_item_name.'" type="'.$input_type.'">';
}
else
{
  print '<br />&nbsp;&nbsp;&nbsp;'.$input_specific;
}

# Add one more input if required
if ($input2_type)
{
  print '<br /><font class="preinput">'.$input2_title.'</font>';
  print '<br />&nbsp;&nbsp;&nbsp;<input type="'.$input2_type.'" name="'.$form_item2_name.'">';

}

# Add one more input if required
if ($input3_type)
{
  print '<br /><font class="preinput">'.$input3_title.'</font>';
  print '<br />&nbsp;&nbsp;&nbsp;<input type="'.$input3_type.'" name="'.$form_item3_name.'">';
}

# Add one more input if required
if ($input4_type)
{
  print '<br /><font class="preinput">'.$input4_title.'</font>';
  print '<br />&nbsp;&nbsp;&nbsp;<input type="'.$input4_type.'" name="'.$form_item4_name.'">';
}

print '<p><input type="hidden" name="item" value="'.$item.'"></p>';
print '<p><input type="submit" name="update" value="'._("Update").'"></p>';
print '</form>';


site_user_footer(array());


?>
