#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Svn.pm,v 1.2 2005/03/20 11:47:20 yeupou Exp $
#
# Copyright 2005      (c) Timothee Besset <ttimo--ttimo.net>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

##
## Desc: any subs related to SVN.
## read-write access: through authenticated ssh, spawning svnserve
## anonymous read: through svnserve daemon on port 3690
##   by default, svnserve only lets read for anonymous, and read-write for authed
##   since the systems have no passwords for users (only ssh keys), one can't auth to the anonymous daemon

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
#our @EXPORT = qw(GetScriptSvnrootInit );
our $version = 1;

sub SvnMakeArea {
    my ($name,$dir_svn) = @_;
    my $warning = "";

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_svn =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_svn) {
	# set the umask right
	my $bak_umask = umask();
	umask( 0002 );
	# fsfs repositories are the most stable and scalable. bdb just doesn't cut it
	`svnadmin create --fs-type fsfs $dir_svn`;
	# create the default repository layout
	`svn mkdir -m "default layout" file://$dir_svn/trunk`;
	`svn mkdir -m "default layout" file://$dir_svn/tags`;
	`svn mkdir -m "default layout" file://$dir_svn/branches`;
	# group ownership
	# svnadmin is expected to set 'set user or group ID on execution (s)' for group on directories
	`chgrp -R $name $dir_svn`;
	umask($bak_umask);
    }
    return 0;
}
