<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: title.php,v 1.3 2005/03/20 11:47:20 yeupou Exp $
#
#  Copyright 2002-2005 (c) Mathieu Roy <yeupou@gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


# Get title depending on the toptab
function title_toptab ($toptab, $group=0)
{
  if ($group) 
    {
      switch ($toptab) 
	    { 
	    case 'home': $title = _("Summary"); break;
	    case 'ahome': $title = _("Summary Administration"); break;
	    case 'forum': $title = _("Forums"); break;
	    case 'bugs': $title = _("Bugs");
	      $GLOBALS['itemtype'] = _("a Bug");
	      $GLOBALS['itemtypes'] = _("Bugs"); break;
	    case 'abugs': $title = _("Bugs Administration");
	      $GLOBALS['itemtype'] = _("a Bug");
	      $GLOBALS['itemtypes'] = _("Bugs"); break;
	    case 'faq': $title = _("Frequently Asked Questions"); break;
	    case 'support': $title = _("Support");
	      $GLOBALS['itemtype'] = _("a Request");
	      $GLOBALS['itemtypes'] = _("Requests"); break;
	    case 'asupport': $title = _("Support Administration");
	      $GLOBALS['itemtype'] = _("a Request");
	      $GLOBALS['itemtypes'] = _("Requests"); break;
	    case 'mail': $title = _("Mailing Lists"); break;
	    case 'amail': $title = _("Mailing Lists"); break;
	    case 'task': $title = _("Tasks");
	      $GLOBALS['itemtype'] = _("a Task");
	      $GLOBALS['itemtypes'] = _("Tasks"); break;
	    case 'atask': $title = _("Tasks Administration"); 
	      $GLOBALS['itemtype'] = _("a Task");
	      $GLOBALS['itemtypes'] = _("Tasks"); break;
	    case 'cvs': $title = _("SCM: CVS Repositories"); break;
	    case 'arch': $title = _("SCM: GNU Arch Repositories"); break;
	    case 'svn': $title = _("SCM: Subversion Repositories"); break;
	    case 'news': $title = _("News"); break;
	    case 'anews': $title = _("News Administration"); break;
	    case 'patch': $title = _("Patches");
	      $GLOBALS['itemtype'] = _("a Patch");
	      $GLOBALS['itemtypes'] = _("Patches"); break;
	    case 'apatch': $title = _("Patches Administration"); 
	      $GLOBALS['itemtype'] = _("a Patch");
	      $GLOBALS['itemtypes'] = _("Patches"); break;
	    case 'download': $title = _("Filelist"); break;
	    case 'adownload': $title = _("Filelist Administration"); break;
	    case 'admin': $title = _("Administration"); break;
	    default: $title = _("Summary"); break;
	    }
      
      $project = project_get_object($group);
      $title = sprintf("%s - ", $project->getPublicName()).$title;

      return $title;
      
    } 
  else 
    {
      switch ($toptab) 
	{
	case 'my': $title = _("My Incoming Items"); break;
	case 'myitems': $title = _("My Items"); break;
	case 'account': $title = _("My Account Configuration"); break;
	case 'mygroups': $title = _("My Group Membership"); break;
	case 'bookmark': $title = _("My Bookmarks"); break;
	}
      
      return $title;
    }
  
}

function title_toptab_icon ($toptab, $group=0)
{

}


?>